/*  XMMS - Cross-platform multimedia player
 *  Copyright (C) 1998-2000  Peter Alm, Mikael Alm, Olle Hallnas, Thomas Nilsson and 4Front Technologies
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
#include "eq.h"

void EQhslider_set_position(HSlider * hs, gint pos)
{
	if (pos == hs->hs_position || hs->hs_pressed)
		return;
	hs->hs_position = pos;
	if (hs->hs_frame_cb)
		hs->hs_frame = hs->hs_frame_cb(hs->hs_position);
//	draw_widget(hs);
}

void EQhslider_draw(Widget * w)
{
	HSlider *hs = (HSlider *) w;
	GdkPixmap *obj, *pix;

	obj = hs->hs_widget.parent;

	// hs->hs_skin_index is always SKIN_EQSHADE for now, see equalizer.c
	pix = EQshade;

	gdk_draw_pixmap(obj, hs->hs_widget.gc, pix,
			 hs->hs_frame_offset, hs->hs_frame * hs->hs_frame_height,
			 hs->hs_widget.x, hs->hs_widget.y, hs->hs_widget.width,
			 hs->hs_widget.height);
	if (hs->hs_pressed)
		gdk_draw_pixmap(obj, hs->hs_widget.gc,
				 pix, hs->hs_knob_px,
				 hs->hs_knob_py, hs->hs_widget.x + hs->hs_position,
				 hs->hs_widget.y +
				 ((hs->hs_widget.height - hs->hs_knob_height) / 2),
				 hs->hs_knob_width, hs->hs_knob_height);
	else
		gdk_draw_pixmap(obj, hs->hs_widget.gc, pix,
				 hs->hs_knob_nx, hs->hs_knob_ny,
				 hs->hs_widget.x + hs->hs_position,
				 hs->hs_widget.y +
				 ((hs->hs_widget.height - hs->hs_knob_height) / 2),
				 hs->hs_knob_width, hs->hs_knob_height);
}

HSlider *EQcreate_hslider(GList ** wlist, GdkPixmap * parent, GdkGC * gc, gint x,
			gint y, gint w, gint h,	gint knx, gint kny, gint kpx,
			gint kpy, gint kw, gint kh, gint fh, gint fo, gint min,
			gint max, gint(*fcb) (gint), void (*mcb) (gint),
			void (*rcb) (gint), SkinIndex si)
{
	HSlider *hs;

	hs = (HSlider *) g_malloc0(sizeof (HSlider));
	hs->hs_widget.parent = parent;
	hs->hs_widget.gc = gc;
	hs->hs_widget.x = x;
	hs->hs_widget.y = y;
	hs->hs_widget.width = w;
	hs->hs_widget.height = h;
	hs->hs_widget.visible = 1;
	hs->hs_widget.button_press_cb = GTK_SIGNAL_FUNC(hslider_button_press_cb);
	hs->hs_widget.button_release_cb = GTK_SIGNAL_FUNC(hslider_button_release_cb);
	hs->hs_widget.motion_cb = GTK_SIGNAL_FUNC(hslider_motion_cb);
	hs->hs_widget.draw = EQhslider_draw;
	hs->hs_knob_nx = knx;
	hs->hs_knob_ny = kny;
	hs->hs_knob_px = kpx;
	hs->hs_knob_py = kpy;
	hs->hs_knob_width = kw;
	hs->hs_knob_height = kh;
	hs->hs_frame_height = fh;
	hs->hs_frame_offset = fo;
	hs->hs_min = min;
	hs->hs_position = min;
	hs->hs_max = max;
	hs->hs_frame_cb = fcb;
	hs->hs_motion_cb = mcb;
	hs->hs_release_cb = rcb;
	if (hs->hs_frame_cb)
		hs->hs_frame = hs->hs_frame_cb(0);
	hs->hs_skin_index = si;
	add_widget(wlist, hs);

	return hs;
}
