/*  XMMS - Cross-platform multimedia player
 *  Copyright (C) 1998-2000  Peter Alm, Mikael Alm, Olle Hallnas, Thomas Nilsson and 4Front Technologies
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
#include "eq.h"

void EQpbutton_draw(Widget * w)
{
	PButton *button = (PButton *) w;
	GdkPixmap *obj, *pix;

	switch (button->pb_skin_index1)
	{
		case SKIN_EQMAIN:
			pix = EQpixmap;
			break;
		case SKIN_EQQUICK:
			pix = EQquick;
			break;
		case SKIN_EQSHADE:
			pix = EQshade;
			break;
		default:
			pix = EQpixmap;
			break;
	}

	if (button->pb_allow_draw)
	{
		obj = button->pb_widget.parent;

		if (button->pb_pressed && button->pb_inside)
		{
			gdk_draw_pixmap(obj, button->pb_widget.gc,
					 pix, button->pb_px,
					 button->pb_py, button->pb_widget.x,
					 button->pb_widget.y,
					 button->pb_widget.width,
					 button->pb_widget.height);
		}
		else
		{
			gdk_draw_pixmap(obj, button->pb_widget.gc,
					 pix,
					 button->pb_nx, button->pb_ny,
					 button->pb_widget.x, button->pb_widget.y,
					 button->pb_widget.width,
					 button->pb_widget.height);
		}
	}
}


PButton *EQcreate_pbutton_ex(GList ** wlist, GdkPixmap * parent, GdkGC * gc, gint x, gint y, gint w, gint h, gint nx, gint ny, gint px, gint py, void (*cb) (void), SkinIndex si)
{
	PButton *b;

	b = (PButton *) g_malloc0(sizeof (PButton));
	b->pb_widget.parent = parent;
	b->pb_widget.gc = gc;
	b->pb_widget.x = x;
	b->pb_widget.y = y;
	b->pb_widget.width = w;
	b->pb_widget.height = h;
	b->pb_widget.visible = 1;
	b->pb_widget.button_press_cb = GTK_SIGNAL_FUNC(pbutton_button_press_cb);
	b->pb_widget.button_release_cb = GTK_SIGNAL_FUNC(pbutton_button_release_cb);
	b->pb_widget.motion_cb = GTK_SIGNAL_FUNC(pbutton_motion_cb);
	b->pb_widget.draw = EQpbutton_draw;
	b->pb_nx = nx;
	b->pb_ny = ny;
	b->pb_px = px;
	b->pb_py = py;
	b->pb_push_cb = cb;
	b->pb_allow_draw = TRUE;
	b->pb_skin_index1 = si;
	add_widget(wlist, b);
	return b;
}

PButton *EQcreate_pbutton(GList ** wlist, GdkPixmap * parent, GdkGC * gc, gint x, gint y, gint w, gint h, gint nx, gint ny, gint px, gint py, void (*cb) (void), SkinIndex si)
{
	return EQcreate_pbutton_ex(wlist, parent, gc, x, y, w, h, nx, ny, px, py, cb, si);
}
