/*  eqskin.h
 *  header for skin support in EQ plugin
 *  (c) 2003 by Simone Karin Lehmann <simone@lisanet.de>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef eqskin_h_
#define eqskin_h_

#include <gdk/gdk.h>

typedef enum
{
	SKIN_EQMAIN, SKIN_EQSHADE, SKIN_EQQUICK
} SkinIndex;


GdkPixmap *eq_create_skin_bg_pixmap(GdkWindow  *window);
GdkPixmap *eq_skin_controls(void);
GdkPixmap *eq_skin_quick(void);
GdkPixmap *eq_skin_title(void);
GdkPixmap *eq_skin_shade(void);
gint eq_skin_width(void);
gint eq_skin_goffset(void);

GdkPixmap *eq_load_default_skin(GdkWindow  *window);
GdkPixmap *eq_load_skin(GdkWindow  *window);
char *eq_decompress_skin(const char* path);
void del_directory(const char *dirname);



#endif // eqskin_h_
