/*  XMMS - Cross-platform multimedia player
 *  Copyright (C) 1998-2001  Peter Alm, Mikael Alm, Olle Hallnas, Thomas Nilsson and 4Front Technologies
 *  Copyright (C) 1999-2001  Haavard Kvaalen
 *
 *  modified a bit to fit for skin support in EQ plugin, 2003 Simone Karin Lehmann
 *
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
#include "eq.h"
#include "eqskinwin.h"

#include <stdlib.h>
#include <errno.h>
#include <sys/stat.h>
#include <sys/types.h>
#include <sys/ipc.h>
#include <ctype.h>
#include <dirent.h>


GtkWidget *eqskinwin, *eqskinwin_list, *eqskinwin_close;
GList *eqskinlist = NULL;

char *_skin_path = "default";


gint eq_skinwin_delete_event(GtkWidget * widget, GdkEvent * event, gpointer data)
{
	gtk_widget_hide(GTK_WIDGET(eqskinwin));
	return (TRUE);
}

void eq_change_skin_event(GtkWidget * widget, gint row, gint column, GdkEventButton * event)
{
	if (row == 0)
		_skin_path = "default";
	else
		_skin_path = ((struct EQSkinNode *) g_list_nth(eqskinlist, row - 1)->data)->path;

	eq_apply_skin(_skin_path);

}

void eq_create_skin_window(GtkWindow *window)
{
	char *titles[1];
	GtkWidget *vbox, *hbox, *main_hbox, *separator, *scrolled_win; //, *checkbox;

	eqskinwin = gtk_window_new(GTK_WINDOW_DIALOG);
	gtk_window_set_title(GTK_WINDOW(eqskinwin), "EQ Equalizer Skins");
	gtk_window_set_transient_for(GTK_WINDOW(eqskinwin), GTK_WINDOW(window));
	gtk_signal_connect(GTK_OBJECT(eqskinwin), "delete_event", GTK_SIGNAL_FUNC(eq_skinwin_delete_event), NULL);
	gtk_container_border_width(GTK_CONTAINER(eqskinwin), 10);

	vbox = gtk_vbox_new(FALSE, 5);
	gtk_container_add(GTK_CONTAINER(eqskinwin), vbox);

	titles[0] = "EQ Skins";
	eqskinwin_list = gtk_clist_new_with_titles(1, titles);

	gtk_clist_column_titles_passive(GTK_CLIST(eqskinwin_list));
	gtk_clist_set_selection_mode(GTK_CLIST(eqskinwin_list), GTK_SELECTION_SINGLE);
	gtk_signal_connect(GTK_OBJECT(eqskinwin_list), "select_row", GTK_SIGNAL_FUNC(eq_change_skin_event), NULL);
	gtk_widget_set_usize(GTK_WIDGET(eqskinwin_list), 250, 200);

	scrolled_win = gtk_scrolled_window_new(NULL, NULL);

	gtk_container_add(GTK_CONTAINER(scrolled_win), eqskinwin_list);
	gtk_container_border_width(GTK_CONTAINER(scrolled_win), 5);
	gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(scrolled_win), GTK_POLICY_AUTOMATIC, GTK_POLICY_ALWAYS);
	gtk_box_pack_start(GTK_BOX(vbox), scrolled_win, TRUE, TRUE, 0);

	separator = gtk_hseparator_new();

	gtk_box_pack_start(GTK_BOX(vbox), separator, FALSE, TRUE, 0);
	main_hbox = gtk_hbox_new(FALSE,5);
	gtk_box_set_spacing(GTK_BOX(main_hbox),5);
	gtk_box_pack_start(GTK_BOX(vbox), main_hbox, FALSE, FALSE, 0);

	hbox = gtk_hbutton_box_new();
	gtk_button_box_set_layout(GTK_BUTTON_BOX(hbox), GTK_BUTTONBOX_END);
	gtk_button_box_set_spacing(GTK_BUTTON_BOX(hbox), 5);
	gtk_box_pack_start(GTK_BOX(main_hbox), hbox, TRUE, TRUE, 0);

	eqskinwin_close = gtk_button_new_with_label("Close");
	GTK_WIDGET_SET_FLAGS(eqskinwin_close, GTK_CAN_DEFAULT);
	gtk_signal_connect(GTK_OBJECT(eqskinwin_close), "clicked", GTK_SIGNAL_FUNC(eq_skinwin_delete_event), NULL);
	gtk_box_pack_start(GTK_BOX(hbox), eqskinwin_close, FALSE, FALSE, 0);

	gtk_widget_grab_default(GTK_WIDGET(eqskinwin_close));

}

static void eq_add_skin(gchar * skin)
{
	struct EQSkinNode *node = (struct EQSkinNode *) g_malloc(sizeof (struct EQSkinNode));
	gchar *tmp;

	node->path = skin;

	tmp = strrchr(skin, '/');
	if (!tmp)
		tmp = skin;
	node->name = (char *) g_malloc(strlen(tmp + 1) + 1);
	strcpy(node->name, tmp + 1);
	tmp = strrchr(node->name, '.');
	if (tmp)
	{
		if (!strcasecmp(tmp, ".zip"))
			*tmp = '\0';
		else if(!strcasecmp(tmp, ".wsz"))
			*tmp = '\0';
		else if (!strcasecmp(tmp, ".tgz"))
			*tmp = '\0';
		else if (!strcasecmp(tmp, ".gz"))
			*tmp = '\0';
		else if (!strcasecmp(tmp, ".bz2"))
			*tmp = '\0';
		else if (!strcasecmp(tmp, ".tar"))
			*tmp = '\0';
		tmp = strrchr(node->name, '.');
		if (tmp)
		{		/* maybe we still have to remove a leftover ".tar" */
			if (!strcasecmp(tmp, ".tar"))
				*tmp = '\0';
		}
	}
	eqskinlist = g_list_prepend(eqskinlist, node);
}

static void eq_scan_skindir(char *path)
{
	DIR *dir;
	struct dirent *dirent;
	struct stat statbuf;
	char *file, *tmp;

	if ((dir = opendir(path)) != NULL)
	{
		while ((dirent = readdir(dir)) != NULL)
		{
			if (strcmp(dirent->d_name, ".") && strcmp(dirent->d_name, ".."))
			{
				file = g_strdup_printf("%s/%s", path, dirent->d_name);
				if (!stat(file, &statbuf))
				{
					if (S_ISDIR(statbuf.st_mode))
						eq_add_skin(file);
					else if (S_ISREG(statbuf.st_mode))
					{
						tmp = strrchr(file, '.');
						if (tmp)
						{
							if (!strcasecmp(tmp, ".zip") ||
							    !strcasecmp(tmp, ".wsz") ||
							    !strcasecmp(tmp, ".tgz") ||
							    !strcasecmp(tmp, ".gz") ||
							    !strcasecmp(tmp, ".bz2"))
								eq_add_skin(file);
							else
								g_free(file);
						}
						else
							g_free(file);
					}
					else
						g_free(file);
				}
				else
					g_free(file);
			}
		}
		closedir(dir);
	}
}

static gint eq_skinlist_compare_func(gconstpointer a, gconstpointer b)
{
	return strcasecmp(((struct EQSkinNode *) a)->name, ((struct EQSkinNode *) b)->name);
}

static void eq_skin_free_func(gpointer data, gpointer user_data)
{
	g_free(((struct EQSkinNode *) data)->name);
	g_free(((struct EQSkinNode *) data)->path);
	g_free(data);
}

#ifndef SKIN_BASE_PATH
  #define SKIN_BASE_PATH "/usr/lib/xmms"
#endif
void eq_scan_skins(void)
{
	int i;
	GList *entry;
	char *none, *str, *skinsdir;
	gchar **list;

	none = "(none)";
	if (eqskinlist)
	{
		g_list_foreach(eqskinlist, eq_skin_free_func, NULL);
		g_list_free(eqskinlist);
	}
	eqskinlist = NULL;
	str = g_strconcat(g_get_home_dir(), "/.xmms/EQskins", NULL);
	eq_scan_skindir(str);
	g_free(str);
	str = g_strconcat(SKIN_BASE_PATH, "/EQskins", NULL);
	eq_scan_skindir(str);
	g_free(str);
	eqskinlist = g_list_sort(eqskinlist, eq_skinlist_compare_func);
	skinsdir = getenv("SKINSDIR");
	if (skinsdir)
	{
		list = g_strsplit(skinsdir, ":", 0);
		i = 0;
		while (list[i])
			eq_scan_skindir(list[i++]);
	}

	gtk_clist_freeze(GTK_CLIST(eqskinwin_list));
	gtk_clist_clear(GTK_CLIST(eqskinwin_list));
	gtk_clist_append(GTK_CLIST(eqskinwin_list), &none);
	if (!eqcfg.skin)
		gtk_clist_select_row(GTK_CLIST(eqskinwin_list), 0, 0);

	for (i = 0; i < g_list_length(eqskinlist); i++)
	{
		entry = g_list_nth(eqskinlist, i);
		gtk_clist_append(GTK_CLIST(eqskinwin_list), (gchar **) & ((struct EQSkinNode *) entry->data)->name);
		if (eqcfg.skin)
			if (!strcmp(((struct EQSkinNode *) entry->data)->path, eqcfg.skin))
				gtk_clist_select_row(GTK_CLIST(eqskinwin_list), i + 1, 0);
	}
	gtk_clist_thaw(GTK_CLIST(eqskinwin_list));
}

void eq_show_skin_window(void)
{
	eq_scan_skins();
	gtk_window_set_position(GTK_WINDOW(eqskinwin), GTK_WIN_POS_MOUSE);
	gtk_widget_show_all(eqskinwin);
	gtk_widget_grab_focus(eqskinwin_list);
	if (GTK_CLIST(eqskinwin_list)->selection)
	{
		gtk_clist_moveto(GTK_CLIST(eqskinwin_list), GPOINTER_TO_INT(GTK_CLIST(eqskinwin_list)->selection->data), 0, 0.5, 0.0);
		GTK_CLIST(eqskinwin_list)->focus_row = GPOINTER_TO_INT(GTK_CLIST(eqskinwin_list)->selection->data);
	}
}

char *eq_skin_path(void)
{
	return _skin_path;
}
