/*  XMMS - Cross-platform multimedia player
 *  Copyright (C) 1998-2002  Peter Alm, Mikael Alm, Olle Hallnas,
 *                           Thomas Nilsson and 4Front Technologies
 *  Copyright (C) 1999-2002  Haavard Kvaalen
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
#ifndef EQEQUALIZER_H
#define EQEQUALIZER_H

void EQequalizer_raise(void);
void EQequalizer_move(gint x, gint y);
void EQdraw_equalizer_window(gboolean force);
void EQequalizer_create(void);
void EQequalizer_recreate(void);
void EQequalizer_show(gboolean show);
void EQequalizer_real_show(void);
void EQequalizer_real_hide(void);
void EQequalizer_load_auto_preset(gchar * filename);
void EQequalizer_set_back_pixmap(void);
void EQequalizer_set_volume_slider(gint percent);
void EQequalizer_set_balance_slider(gint percent);
void EQequalizer_eq_changed(gint index, gint chn);
void EQequalizer_set_preamp(gfloat *preamp, gint chn);
void EQequalizer_set_band(gint band, gfloat value, gint chn);
gfloat EQequalizer_get_preamp(gint chn);
gfloat EQequalizer_get_band(gint band, gint chn);
void EQequalizer_set_shape_mask(void);
void EQequalizer_configure_gui(void);


void eq_apply_skin(char *path);

extern GdkPixmap *EQpixmap;
extern GdkPixmap *EQquick;
extern GdkPixmap *EQshade;


#endif
