/*
 *   PCM time-domain equalizer
 *
 *   Copyright (C) 2002-2006  Felipe Rivera <liebremx at users.sourceforge.net>
 *
 *   19.08.2002 Initial release for XMMS
 *
 *   added more about info, skin support, 2003 Simone Karin Lehmann
 *
 *   
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *   $Id: gui.c,v 1.11 2006/01/15 00:13:51 liebremx Exp $
 */

#include "eq.h"
#include "eqskinwin.h"
#include "eqlogo.xpm"

static char *credit_text[] =
{
"      EQ Plugin:", "Felipe Rivera", NULL,
"Skin Support:", "Simone Karin Lehmann", NULL,
"Credits:", "Richard Rauch",
			"Giuliano Pochini",
			"Frank Klemm",
			"Khadiyd Idris",
            "Darabos Edvrd Konrd",
            "Bob McGwier",
            "Alejandro Pulver",
            "Edd Barret",
            "Thomas Cort",
NULL,
"Copyright:","2002 - 2006 under the terms of the",
			"GNU General Public License", NULL,
"Homepage:", "http://equ.sourceforge.net",NULL,
"Skins:","http://www.lisanet.de/eqxmms",NULL,
NULL
};

static char *copyright[] =
{
    "", "This program is free software; you can redistribute it and/or modify",
    "it under the terms of the GNU General Public License as published by",
    "the Free Software Foundation; either version 2 of the License, or",
    "(at your option) any later version.",
    NULL,
    "", "This program is distributed in the hope that it will be useful, but",
    "WITHOUT ANY WARRANTY; without even the implied warranty of",
    "MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.",
    "See the GNU General Public License for more details.",
    NULL,
    "", "You should have received a copy of the GNU General Public License",
    "along with this program; if not, write to the Free Software",
    "Foundation, Inc., 59 Temple Place, Suite 330, Boston,",
    "MA  02111-1307  USA",
    NULL,
    NULL
};

static GtkWidget* generate_credit_list(char *text[], gboolean sec_space)
{
    GtkWidget *clist, *scrollwin;
    int i = 0;

    clist = gtk_clist_new(2);

    while (text[i])
    {
        char *temp[2];
        guint row;

        temp[0] = text[i++];
        temp[1] = text[i++];
        row = gtk_clist_append(GTK_CLIST(clist), temp);
        gtk_clist_set_selectable(GTK_CLIST(clist), row, FALSE);
        temp[0] = "";
        while (text[i])
        {
            temp[1] = text[i++];
            row = gtk_clist_append(GTK_CLIST(clist), temp);
            gtk_clist_set_selectable(GTK_CLIST(clist), row, FALSE);
        }
        i++;
        if (text[i] && sec_space)
        {
            temp[1] = "";
            row = gtk_clist_append(GTK_CLIST(clist), temp);
            gtk_clist_set_selectable(GTK_CLIST(clist), row, FALSE);
        }
    }
    gtk_clist_columns_autosize(GTK_CLIST(clist));
    gtk_clist_set_column_justification(GTK_CLIST(clist), 0, GTK_JUSTIFY_RIGHT);

    scrollwin = gtk_scrolled_window_new(NULL, NULL);
    gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(scrollwin),
            GTK_POLICY_NEVER, GTK_POLICY_ALWAYS);
    gtk_container_add(GTK_CONTAINER(scrollwin), clist);
    gtk_container_set_border_width(GTK_CONTAINER(scrollwin), 10);
    gtk_widget_set_usize(scrollwin, -1, 120);

    return scrollwin;
}


void about(void)
{
    static GtkWidget *eq_about_dialog = NULL;
    static GdkPixmap *logo_pix = NULL;

    GtkWidget *about_vbox, *about_notebook;
    GtkWidget *about_credits_logo_box, *about_credits_logo_frame;
    GtkWidget *about_credits_logo;
    GtkWidget *bbox, *close_btn;
    GtkWidget *label, *list;

    if (eq_about_dialog != NULL)
        return;

    eq_about_dialog = gtk_window_new(GTK_WINDOW_DIALOG);
    gtk_window_set_title(GTK_WINDOW(eq_about_dialog), "About EQ Plugin");
    gtk_window_set_policy(GTK_WINDOW(eq_about_dialog), FALSE, TRUE, FALSE);
    gtk_container_set_border_width(GTK_CONTAINER(eq_about_dialog), 10);
    gtk_signal_connect(GTK_OBJECT(eq_about_dialog), "destroy",
            GTK_SIGNAL_FUNC(gtk_widget_destroyed), &eq_about_dialog);
    gtk_widget_realize(eq_about_dialog);

    about_vbox = gtk_vbox_new(FALSE, 10);
    gtk_container_add(GTK_CONTAINER(eq_about_dialog), about_vbox);

    label = gtk_label_new("EQ Plugin");
    gtk_box_pack_start(GTK_BOX(about_vbox), label, FALSE, FALSE, 0);

    if (!logo_pix)
        logo_pix =
            gdk_pixmap_create_from_xpm_d(eq_about_dialog->window, NULL, NULL, eqlogo_xpm);

    about_credits_logo_box = gtk_hbox_new(TRUE, 0);
    gtk_box_pack_start(GTK_BOX(about_vbox), about_credits_logo_box, FALSE, FALSE, 0);

    about_credits_logo_frame = gtk_frame_new(NULL);
    gtk_frame_set_shadow_type(GTK_FRAME(about_credits_logo_frame), GTK_SHADOW_OUT);
    gtk_box_pack_start(GTK_BOX(about_credits_logo_box), about_credits_logo_frame, FALSE, FALSE, 0);

    about_credits_logo = gtk_pixmap_new(logo_pix, NULL);
    gtk_container_add(GTK_CONTAINER(about_credits_logo_frame),
            about_credits_logo);

    label = gtk_label_new("A multi-channeled and multi-banded equalizer for XMMS\nVersion " VERSION);
    gtk_box_pack_start(GTK_BOX(about_vbox), label, FALSE, FALSE, 0);

    about_notebook = gtk_notebook_new();
    gtk_box_pack_start(GTK_BOX(about_vbox), about_notebook, TRUE, TRUE, 0);

    list = generate_credit_list(credit_text, TRUE);
    gtk_notebook_append_page(GTK_NOTEBOOK(about_notebook), list, gtk_label_new("Credits"));
    list = generate_credit_list(copyright, TRUE);
    gtk_notebook_append_page(GTK_NOTEBOOK(about_notebook), list, gtk_label_new("Copyright"));

    bbox = gtk_hbutton_box_new();
    gtk_button_box_set_layout(GTK_BUTTON_BOX(bbox), GTK_BUTTONBOX_END);
    gtk_button_box_set_spacing(GTK_BUTTON_BOX(bbox), 5);
    gtk_box_pack_start(GTK_BOX(about_vbox), bbox, FALSE, FALSE, 0);

    close_btn = gtk_button_new_with_label("Close");
    gtk_signal_connect_object(GTK_OBJECT(close_btn), "clicked",
            GTK_SIGNAL_FUNC(gtk_widget_destroy),
            GTK_OBJECT(eq_about_dialog));
    GTK_WIDGET_SET_FLAGS(close_btn, GTK_CAN_DEFAULT);
    gtk_box_pack_start(GTK_BOX(bbox), close_btn, TRUE, TRUE, 0);
    gtk_widget_grab_default(close_btn);

    gtk_widget_show_all(eq_about_dialog);

}

void init_gui(void)
{
    eq_read_config();
    EQequalizer_create();
    eq_create_skin_window(GTK_WINDOW(EQequalizerwin));
    EQeqslider_set_names();
    if (eqcfg.gui_visible)
        EQequalizer_real_show();
}

void clean_gui(void)
{
    eq_write_config();

    if (eqskinwin) {
        gtk_widget_destroy(GTK_WIDGET(eqskinwin));
        eqskinwin = NULL;
    }

    if (EQequalizerwin) {
        gtk_widget_destroy(GTK_WIDGET(EQequalizerwin));
        EQequalizerwin = NULL;
    }
    
    eq_has_been_initialized = FALSE;
}
