/***************************************************************************
 *   Copyright (C) 2004 by Sandro Giessl                                   *
 *   ceebx@users.sourceforge.net                                           *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU Library General Public     *
 *   License along with this program; if not, write to the                 *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef EVENTWATCHEREVENTDATA_H
#define EVENTWATCHEREVENTDATA_H

#include <qdatetime.h>
#include <qstring.h>
#include <qpixmap.h>

class QWidget;

namespace EventWatcher {

class EventContainer;

/**
 * The type of an EventAction.
 */
enum ActionType {
    UrlAction, ///< Opens a web browser and loads the url stored in the EventAction data member.
    CommandAction, ///< Executes a command, not implemented yet.
    NoAction ///< Do nothing.
};

/**
 * This class describes an action which might be performed on the user's request and can be used to
 * execute the action.
 */
class EventAction {
public:
    EventAction();
    EventAction(ActionType type, const QString &data = QString::null, const QString &text = QString::null);
    ~EventAction();

    void setAction(ActionType type, const QString &data = QString::null, const QString &text = QString::null);
    bool performAction() const;

    const ActionType& actionType() const;
    const QString& actionData() const;
    const QString& actionText() const;
private:
    ActionType m_type;
    QString m_data,
            m_text;
};

/**
 * This class stores information which describes an event.
 */
class EventData {
public:
    EventData();
    EventData(const QString &shortTitle, const QString &title, const QString &text = QString::null, const QString &icon = QString::null, const EventAction &action = EventAction() );
    ~EventData();
    void setData(const QString &shortTitle, const QString &title, const QString &text = QString::null, const QString &icon = QString::null, const EventAction &action = EventAction() );

    void setDate(const QDate &date); ///< The correct date will already be by the ctor and setData. Normally, you don't want to use this.
    void setTime(const QTime &time); ///< The correct time will already be by the ctor and setData. Normally, you don't want to use this.
    void setShortTitle(const QString& str); ///< A very short event description to be displayed in the popup, for example.
    void setTitle(const QString& str); ///< A bit more informative event description than the shortTitle().
    void setText(const QString& str); ///< The full event text. optional.
    void setIcon(const QString& str); ///< The name of an icon to be loaded by KIconLoader
    void setAction(const EventAction& action); ///< An event action. optional.
    const QTime& time() const; ///<
    const QDate& date() const;
    const QString& shortTitle() const;
    const QString& title() const;
    const QString& text() const;
    const QString& icon() const;
    const EventAction action() const;
private:
    QTime   m_time;
    QDate   m_date;
    QString m_shortTitle,
            m_title,
            m_text,
            m_icon;
    EventAction m_action;
};

};

#endif
