/***************************************************************************
 *   Copyright (C) 2004 by Sandro Giessl                                   *
 *   ceebx@users.sourceforge.net                                           *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU Library General Public     *
 *   License along with this program; if not, write to the                 *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef EVENTWATCHERPLUGIN_H
#define EVENTWATCHERPLUGIN_H

#include <qobject.h>

namespace EventWatcher {

class EventData;

/**
 * This is the base class for an eventwatcher plugin object. It provides
 * methods that give various information about plugin-related
 * settings, and gives the possibility for plugins to create "events".
 */
class Plugin : public QObject
{
Q_OBJECT
public:
    /**
     * Constructs a Plugin object. Both arguments are passed from
     * Factory object.
     */
    Plugin(QObject *parent = 0, const char *name = 0);
    /**
     * Destroys the Plugin object.
     */
    ~Plugin();
public slots:
    /**
     * Will be called when eventwatcher settings have been changed, this
     * includes plugin setting changes by the plugin configuration dialog.
     * Note: This behaviour may change in future so that the plugin will
     * only be notified about changes of its own config dialog.
     */
    virtual void settingsChanged() = 0;
    /**
     * Will be called when eventwatcher's update mode has been changed.
     * Use isOnlineMode() to check the actual setting.
     */
    virtual void onlineSettingChanged() = 0;
    /**
     * Will be called when the plugin is expected to perform an event data
     * update check. May be due to a global update interval or due to an
     * explicit order, e.g. by the user.
     */
    virtual void performUpdateCheck() = 0;
protected:
    /**
     * Note: Not implemented yet, will always return true. However,
     * please try to honor the return value.
     * Returns @a false if the plugin should avoid any kind of internet
     * connection.
     */
    bool isOnlineMode();
    /**
     * Creates an event, convenient method for event(). Provide as many
     * information as possible in the EventData.
     */
    void createEvent(const EventData &data);
signals:
    /**
     * Creates an event.
     */
    void event(const EventData &data);
};

};

#endif
