#!/bin/sh

config() {
  NEW="$1"
  OLD="`dirname $NEW`/`basename $NEW .new`"
  # If there's no config file by that name, mv it over:
  if [ ! -r $OLD ]; then
    mv $NEW $OLD
  elif [ "`cat $OLD | md5sum`" = "`cat $NEW | md5sum`" ]; then # toss the redundant copy
    rm $NEW
  fi
  # Otherwise, we leave the .new copy for the admin to consider...
}
config etc/ffserver.conf.new

( cd usr/lib ; rm -rf libavformat.so )
( cd usr/lib ; ln -sf libavformat.so.51.13.4 libavformat.so )
( cd usr/lib ; rm -rf libavutil.so )
( cd usr/lib ; ln -sf libavutil.so.49.5.0 libavutil.so )
( cd usr/lib ; rm -rf libswscale.so )
( cd usr/lib ; ln -sf libswscale.so.0.5.0 libswscale.so )
( cd usr/lib ; rm -rf libswscale.so.0 )
( cd usr/lib ; ln -sf libswscale.so.0.5.0 libswscale.so.0 )
( cd usr/lib ; rm -rf libavutil.so.49 )
( cd usr/lib ; ln -sf libavutil.so.49.5.0 libavutil.so.49 )
( cd usr/lib ; rm -rf libavformat.so.51 )
( cd usr/lib ; ln -sf libavformat.so.51.13.4 libavformat.so.51 )
( cd usr/lib ; rm -rf libavcodec.so.51 )
( cd usr/lib ; ln -sf libavcodec.so.51.44.0 libavcodec.so.51 )
( cd usr/lib ; rm -rf libavcodec.so )
( cd usr/lib ; ln -sf libavcodec.so.51.44.0 libavcodec.so )
( cd usr/lib ; rm -rf libpostproc.so.51 )
( cd usr/lib ; ln -sf libpostproc.so.51.1.0 libpostproc.so.51 )
( cd usr/lib ; rm -rf libpostproc.so )
( cd usr/lib ; ln -sf libpostproc.so.51.1.0 libpostproc.so )
