#!/bin/bash
#
# FLVGET Plugin for "Google Video" version 1.2
# http://video.google.com/
#
# This plugin is released under GPL free license.
#
# Pablo Chinea <khertz@gmail.com>
#################################################

if [[ $1 == '-q' ]]
then
	echo "FLVGET_PLUGIN|Google Video|video.google."
	exit 0
fi

extra=$(echo "$1" | sed -e 's/videoplay/videohosted/')

opt=$(kdialog --title "Google Video" --radiolist "Select file format to download" flv "FLV (Flash Video)" 0 avi "AVI (DivX)" 0 mp4 "MP4 (iPod, PSP, ...)" 0)

case "$opt" in
	flv)
		url=$(wget -q "$1" -O - | grep VideoPlayback | sed -e 's/.*videoUrl=\(.*\)\&messagesUrl.*/\1/' -e 's/%3A/:/' -e 's/%2F/\//g' -e 's/%3F/\?/' -e 's/%3D/=/g' -e 's/%26/\&/g')
		ext="flv"
	;;
	avi)
		url=$(wget -q "$extra" -O - | grep macdownloadlink | cut -d'"' -f8 | sed -e 's/\&amp\;/\&/g')
		ext="avi"
	;;
	mp4)
		url=$(wget -q "$extra" -O - | grep ipoddownloadlink | cut -d'"' -f8 | sed -e 's/\&amp\;/\&/g')
		ext="mp4"
	;;
esac

filename=$(echo "$1" | sed -e 's/.*doc[Ii]d=\([0-9]*\).*/\1/').$ext



echo "$url|$filename"
