#!/bin/bash
#
# FLVGET Plugin for "Goyk.com" version 1.1
# http://www.goyk.com/
#
# This plugin is released under GPL free license.
#
# Pablo Chinea <khertz@gmail.com>
#################################################

if [[ $1 == '-q' ]]
then
	echo "FLVGET_PLUGIN|Goyk.com|goyk.com"
	exit 0
fi

url=$(wget -q "$1" -O - | grep embed | head -1 | cut -d'"' -f2)

if [[ -n "$(echo "$url" | grep youtube)" ]]
then
	id=$(echo "$url" | cut -d'/' -f5)
	yt="http://www.youtube.com/watch?v=$id"
	$(dirname $0)/youtube.sh "$yt"
	exit
fi

if [[ -n "$(echo "$url" | grep google)" ]]
then
	id=$(echo "$url" | sed -e 's/.*doc[Ii]d=\([0-9]*\).*/\1/')
	gv="http://video.google.es/videoplay?docid=$id"
	$(dirname $0)/google.sh "$gv"
	exit
fi

filename=$(echo "$url" | sed -e 's/.*\/\(.*\)$/\1/')

echo "$url|$filename"
