/*
 * Example Gnaural low-level D-Bus client.
 */
#include <dbus/dbus.h>
#include <stdbool.h>
#include <unistd.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h> //ONLY needed for g_usleep()
#include "gnaural-dbus-server.h"

//globals:
DBusConnection *gdec_remote_connection = NULL;

//////////////////////////
//Call a method on a remote object
double GetBeatfreq (unsigned int voice)
{
 DBusMessage *msg;
 DBusMessageIter args;
 DBusPendingCall *pending;
 DBusError err;
 double result;

 // initialise the errors
 dbus_error_init (&err);

 // create a new method call and check for errors:
 msg = dbus_message_new_method_call (GNAURAL_DBUS_SERVER,	// target for the method call
				     GNAURAL_DBUS_OBJECT,	// object to call on
				     GNAURAL_DBUS_INTERFACE,	// interface to call on
				     "GetBeatfreq");	// method name
 if (NULL == msg)
 {
  fprintf (stderr, "Message Null\n");
  exit (1);
 }

 //initialize an "iter" (argument list), the append arguments:
 dbus_message_iter_init_append (msg, &args);
 if (!dbus_message_iter_append_basic (&args, DBUS_TYPE_UINT32, &voice))
 {
  fprintf (stderr, "Out Of Memory!\n");
  exit (1);
 }

 // send message and get a handle for a reply
 if (!dbus_connection_send_with_reply
     (gdec_remote_connection, msg, &pending, -1))
 {	// -1 is default timeout
  fprintf (stderr, "Out Of Memory!\n");
  exit (1);
 }
 if (NULL == pending)
 {
  fprintf (stderr, "Pending Call Null\n");
  exit (1);
 }
 dbus_connection_flush (gdec_remote_connection);

 // free message
 dbus_message_unref (msg);

 // block until we recieve a reply
 dbus_pending_call_block (pending);

 // get the reply message
 msg = dbus_pending_call_steal_reply (pending);
 if (NULL == msg)
 {
  fprintf (stderr, "Reply Null\n");
  exit (1);
 }
 // free the pending message handle
 dbus_pending_call_unref (pending);

 // read the parameters
 if (!dbus_message_iter_init (msg, &args))
 {
  fprintf (stderr, "Message has no arguments!\n");
 }
 else if (DBUS_TYPE_DOUBLE != dbus_message_iter_get_arg_type (&args))
 {
  fprintf (stderr, "Argument is not double!\n");
  exit (1);
 }
 else
 {
  dbus_message_iter_get_basic (&args, &result);
 }

 // printf ("Got Reply. Beatfreq: %g\n", result);

 // free reply 
 dbus_message_unref (msg);
 return result;
}

//////////////////////////
//Call a method on a remote object
double GetBasefreq (unsigned int voice)
{
 DBusMessage *msg;
 DBusMessageIter args;
 DBusPendingCall *pending;
 DBusError err;
 double result;

 // initialise the errors
 dbus_error_init (&err);

 // create a new method call and check for errors:
 msg = dbus_message_new_method_call (GNAURAL_DBUS_SERVER,	// target for the method call
				     GNAURAL_DBUS_OBJECT,	// object to call on
				     GNAURAL_DBUS_INTERFACE,	// interface to call on
				     "GetBasefreq");	// method name
 if (NULL == msg)
 {
  fprintf (stderr, "Message Null\n");
  exit (1);
 }

 //initialize an "iter" (argument list), the append arguments:
 dbus_message_iter_init_append (msg, &args);
 if (!dbus_message_iter_append_basic (&args, DBUS_TYPE_UINT32, &voice))
 {
  fprintf (stderr, "Out Of Memory!\n");
  exit (1);
 }

 // send message and get a handle for a reply
 if (!dbus_connection_send_with_reply
     (gdec_remote_connection, msg, &pending, -1))
 {	// -1 is default timeout
  fprintf (stderr, "Out Of Memory!\n");
  exit (1);
 }
 if (NULL == pending)
 {
  fprintf (stderr, "Pending Call Null\n");
  exit (1);
 }
 dbus_connection_flush (gdec_remote_connection);

 // free message
 dbus_message_unref (msg);

 // block until we recieve a reply
 dbus_pending_call_block (pending);

 // get the reply message
 msg = dbus_pending_call_steal_reply (pending);
 if (NULL == msg)
 {
  fprintf (stderr, "Reply Null\n");
  exit (1);
 }
 // free the pending message handle
 dbus_pending_call_unref (pending);

 // read the parameters
 if (!dbus_message_iter_init (msg, &args))
 {
  fprintf (stderr, "Message has no arguments!\n");
 }
 else if (DBUS_TYPE_DOUBLE != dbus_message_iter_get_arg_type (&args))
 {
  fprintf (stderr, "Argument is not double!\n");
  exit (1);
 }
 else
 {
  dbus_message_iter_get_basic (&args, &result);
 }

 // printf ("Got Reply. Beatfreq: %g\n", result);

 // free reply 
 dbus_message_unref (msg);
 return result;
}

//////////////////////////
//Call a method on a remote object
unsigned int GetVoicetype (unsigned int voice)
{
 DBusMessage *msg;
 DBusMessageIter args;
 DBusPendingCall *pending;
 DBusError err;
 unsigned int result;

 // initialise the errors
 dbus_error_init (&err);

 // create a new method call and check for errors:
 msg = dbus_message_new_method_call (GNAURAL_DBUS_SERVER,	// target for the method call
				     GNAURAL_DBUS_OBJECT,	// object to call on
				     GNAURAL_DBUS_INTERFACE,	// interface to call on
				     "GetVoicetype");	// method name
 if (NULL == msg)
 {
  fprintf (stderr, "Message Null\n");
  exit (1);
 }

 //initialize an "iter" (argument list), the append arguments:
 dbus_message_iter_init_append (msg, &args);
 if (!dbus_message_iter_append_basic (&args, DBUS_TYPE_UINT32, &voice))
 {
  fprintf (stderr, "Out Of Memory!\n");
  exit (1);
 }

 // send message and get a handle for a reply
 if (!dbus_connection_send_with_reply
     (gdec_remote_connection, msg, &pending, -1))
 {	// -1 is default timeout
  fprintf (stderr, "Out Of Memory!\n");
  exit (1);
 }
 if (NULL == pending)
 {
  fprintf (stderr, "Pending Call Null\n");
  exit (1);
 }
 dbus_connection_flush (gdec_remote_connection);

 // free message
 dbus_message_unref (msg);

 // block until we recieve a reply
 dbus_pending_call_block (pending);

 // get the reply message
 msg = dbus_pending_call_steal_reply (pending);
 if (NULL == msg)
 {
  fprintf (stderr, "Reply Null\n");
  exit (1);
 }
 // free the pending message handle
 dbus_pending_call_unref (pending);

 // read the parameters
 if (!dbus_message_iter_init (msg, &args))
 {
  fprintf (stderr, "Message has no arguments!\n");
 }
 else if (DBUS_TYPE_UINT32 != dbus_message_iter_get_arg_type (&args))
 {
  fprintf (stderr, "Argument is not DBUS_TYPE_UINT32!\n");
  exit (1);
 }
 else
 {
  dbus_message_iter_get_basic (&args, &result);
 }

 // free reply 
 dbus_message_unref (msg);
 return result;
}

//////////////////////////
//Call a method on a remote object
unsigned int GetVoicecount (void)
{
 DBusMessage *msg;
 DBusMessageIter args;
 DBusPendingCall *pending;
 DBusError err;
 unsigned int result;

 // initialise the errors
 dbus_error_init (&err);

 // create a new method call and check for errors:
 msg = dbus_message_new_method_call (GNAURAL_DBUS_SERVER,	// target for the method call
				     GNAURAL_DBUS_OBJECT,	// object to call on
				     GNAURAL_DBUS_INTERFACE,	// interface to call on
				     "GetVoicecount");	// method name
 if (NULL == msg)
 {
  fprintf (stderr, "Message Null\n");
  exit (1);
 }

 //initialize an "iter" (argument list), the append arguments:
 dbus_message_iter_init_append (msg, &args);

 // send message and get a handle for a reply
 if (!dbus_connection_send_with_reply
     (gdec_remote_connection, msg, &pending, -1))
 {	// -1 is default timeout
  fprintf (stderr, "Out Of Memory!\n");
  exit (1);
 }
 if (NULL == pending)
 {
  fprintf (stderr, "Pending Call Null\n");
  exit (1);
 }
 dbus_connection_flush (gdec_remote_connection);

 // free message
 dbus_message_unref (msg);

 // block until we recieve a reply
 dbus_pending_call_block (pending);

 // get the reply message
 msg = dbus_pending_call_steal_reply (pending);
 if (NULL == msg)
 {
  fprintf (stderr, "Reply Null\n");
  exit (1);
 }
 // free the pending message handle
 dbus_pending_call_unref (pending);

 // read the parameters
 if (!dbus_message_iter_init (msg, &args))
 {
  fprintf (stderr, "Message has no arguments!\n");
 }
 else if (DBUS_TYPE_UINT32 != dbus_message_iter_get_arg_type (&args))
 {
  fprintf (stderr, "Argument is not DBUS_TYPE_UINT32!\n");
  exit (1);
 }
 else
 {
  dbus_message_iter_get_basic (&args, &result);
 }

 // free reply 
 dbus_message_unref (msg);
 return result;
}

//////////////////////////
void gdec_init_connection (void)
{
 DBusError err;
 int ret;

 // initialise the errors
 dbus_error_init (&err);

 // connect to the system bus and check for errors
 gdec_remote_connection = dbus_bus_get (DBUS_BUS_SESSION, &err);
 if (dbus_error_is_set (&err))
 {
  fprintf (stderr, "Connection Error (%s)\n", err.message);
  dbus_error_free (&err);
 }
 if (NULL == gdec_remote_connection)
 {
  exit (1);
 }

 // request our name on the bus
 ret =
  dbus_bus_request_name (gdec_remote_connection, "test.method.caller",
			 DBUS_NAME_FLAG_REPLACE_EXISTING, &err);
 if (dbus_error_is_set (&err))
 {
  fprintf (stderr, "Name Error (%s)\n", err.message);
  dbus_error_free (&err);
 }
 if (DBUS_REQUEST_NAME_REPLY_PRIMARY_OWNER != ret)
 {
  exit (1);
 }
}

//////////////////////////
int main (int argc, char **argv)
{
 gdec_init_connection ();
 while (1)
 {
  fprintf (stderr, "GetVoicecount (): %u\n", GetVoicecount ());
  fprintf (stderr, "GetVoicetype (0): %u\n", GetVoicetype (0));
  fprintf (stderr, "GetBeatfreq  (0): %g\n", GetBeatfreq (0));
  fprintf (stderr, "GetBasefreq  (0): %g\n", GetBasefreq (0));
  g_usleep (G_USEC_PER_SEC);
 }
 printf ("all done\n");
 return 0;
}
