/*
   gnaural-dbus-flasher.c
   A hack to demonstrate how Gnaural can give information over D-Bus
   (the rgbbuf version has proven fastest)
   This is the rgbbuf version (interchangeable with the drawing_area version)
   Copyright (C) 2007  Bret Logan

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include <gtk/gtk.h>
//program globals for gnaural-dbus-flasher.c:
const int gdf_voice = 0;	//a real app would allow user to choose voice
int gdf_timeout_id = 0;
double gdf_beatfreq = 0;	//the only use of D-Bus here is to set this variable once-a-sec
gboolean main_ToggleFlasher (gpointer data);

//flasher.c -- (GTK+2 program) a toggling image flipper, toggles between
//flasher_pixbuf1 and flasher_pixbuf2
//To use:
// gint w=1, h=1;
// main_FD = flasher_Init (w, h, 0xFF0000, 0x0000FF);
// (put it in your GtkHBox -- like this: gtk_box_pack_start (GTK_BOX (hbox), GTK_WIDGET (main_FD->drawing_area), TRUE, TRUE, 0);
// flasher_Cleanup (main_FD);

#include <stdlib.h>
#include <math.h>
#include "gnaural-dbus-flasher.h"
//////////////////////////////

//////////////////////////////
//this should ONLY be called with already cleaned flasher_Data
flasher_Data *flasher_Init (int WIDTH, int HEIGHT, int color1, int color2)
{
 flasher_Data *fd = (flasher_Data *) malloc (sizeof (flasher_Data));

 flasher_InitData (fd);
 fd->color1 = color1;
 fd->color2 = color2;
 // flasher_Cleanup (fd);
 fd->drawing_area = gtk_drawing_area_new ();
 gtk_drawing_area_size (GTK_DRAWING_AREA (fd->drawing_area), WIDTH, HEIGHT);
 //flasher_Render (fd); 

 // --- Signals used to handle backing rgbbuf 
 gtk_signal_connect (GTK_OBJECT (fd->drawing_area), "expose_event",
		     (GtkSignalFunc) flasher_expose_event, fd);
 gtk_signal_connect (GTK_OBJECT (fd->drawing_area), "configure_event",
		     (GtkSignalFunc) flasher_configure_event, fd);
 return fd;
}

//////////////////////////////
void flasher_Cleanup (flasher_Data * fd)
{
 //Free background if we created it
 if (NULL != fd->rgbbuf)
 {
  //fprintf (stderr, "deleting old rgbbuf\n");
  free (fd->rgbbuf);
 }

 if (NULL != fd)
 {
  free (fd);
 }
}

//////////////////////////////
void flasher_Render (flasher_Data * fd)
{
 if (fd->size <= 0)
 {
  return;
 }

 fd->ToggleState = ~fd->ToggleState;
 flasher_Fill (fd);

 gdk_window_invalidate_rect (fd->drawing_area->window, NULL, FALSE);
 // gtk_widget_queue_draw_area (fd->drawing_area, 0, 0, fd->width,fd->height); 
 /*
    GdkRectangle update_rect;
    update_rect.x = 0;
    update_rect.y = 0;
    update_rect.width = fd->width;
    update_rect.height = fd->height;
    gtk_widget_draw (fd->drawing_area, &update_rect);
  */
}

//////////////////////////////
void flasher_InitData (flasher_Data * fd)
{
 fd->drawing_area = NULL;
 fd->ToggleState = 0;
 fd->width = 0;
 fd->height = 0;
 fd->size = 0;
 fd->rowstride = 0;
 fd->rgbbuf = NULL;
 fd->color1 = 0xffffffff;
 fd->color2 = 0;
}

//////////////////////////////
void flasher_Fill (flasher_Data * fd)
{
 // Set up the RGB buffer:
 guchar r,
  g,
  b;

 if (0 == fd->ToggleState)
 {
  r = (guchar) (fd->color1 >> 0) & 0xff;
  g = (guchar) (fd->color1 >> 8) & 0xff;
  b = (guchar) (fd->color1 >> 16) & 0xff;
 }
 else
 {
  r = (guchar) (fd->color2 >> 0) & 0xff;
  g = (guchar) (fd->color2 >> 8) & 0xff;
  b = (guchar) (fd->color2 >> 16) & 0xff;
 }

 guchar *pos = fd->rgbbuf;
 int i = fd->size;

 while (i > 1)
 {
  *pos++ = r;
  *pos++ = g;
  *pos++ = b;
  i -= 3;
 }
}

//////////////////////////////
gint flasher_expose_event (GtkWidget * widget, GdkEventExpose * event,
			   flasher_Data * fd)
{

 gdk_draw_rgb_image (widget->window,
		     widget->style->fg_gc[GTK_STATE_NORMAL],
		     0,
		     0,
		     fd->width,
		     fd->height,
		     GDK_RGB_DITHER_NONE, fd->rgbbuf, fd->rowstride);
 return FALSE;
}

//////////////////////////////
gint flasher_configure_event (GtkWidget * widget,
			      GdkEventConfigure * event, flasher_Data * fd)
{
 //erase any old rgb array:
 if (NULL != fd->rgbbuf)
 {
  //fprintf (stderr, "deleting old rgbbuf\n");
  free (fd->rgbbuf);
 }

 fd->width = widget->allocation.width;
 fd->height = widget->allocation.height;
 fd->rowstride = 3 * fd->width;
 fd->size = fd->rowstride * fd->height;
 //create new array to hold colors:
 fd->rgbbuf = (guchar *) malloc (fd->size);

 //fill it (optional):
 //flasher_Fill (fd);
 return TRUE;
}

/////////////////////////////////////////////////
/////////////////////////////////////////////////
//Following was in gnaural-dbus-client-example.c:
#include <dbus/dbus.h>
#include <stdbool.h>
#include <unistd.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "gnaural-dbus-server.h"

//global:
//DBusConnection *gdec_remote_connection = NULL;

//////////////////////////
//Call a method on a remote object
double GetBeatfreq (DBusConnection * gdec_remote_connection, unsigned int voice)
{
 DBusMessage *msg;
 DBusMessageIter args;
 DBusPendingCall *pending;
 double result;

 // create a new method call and check for errors:
 msg = dbus_message_new_method_call (GNAURAL_DBUS_SERVER,	// target for the method call
				     GNAURAL_DBUS_OBJECT,	// object to call on
				     GNAURAL_DBUS_INTERFACE,	// interface to call on
				     "GetBeatfreq");	// method name
 if (NULL == msg)
 {
  fprintf (stderr, "Message Null\n");
  exit (1);
 }

 //initialize an "iter" (argument list), the append arguments:
 dbus_message_iter_init_append (msg, &args);
 if (!dbus_message_iter_append_basic (&args, DBUS_TYPE_UINT32, &voice))
 {
  fprintf (stderr, "Out Of Memory!\n");
  exit (1);
 }

 // send message and get a handle for a reply
 if (!dbus_connection_send_with_reply
     (gdec_remote_connection, msg, &pending, -1))
 {	// -1 is default timeout
  fprintf (stderr, "Out Of Memory!\n");
  exit (1);
 }
 if (NULL == pending)
 {
  fprintf (stderr, "Pending Call Null\n");
  exit (1);
 }
 dbus_connection_flush (gdec_remote_connection);

 // free message
 dbus_message_unref (msg);

 // block until we recieve a reply
 dbus_pending_call_block (pending);

 // get the reply message
 msg = dbus_pending_call_steal_reply (pending);
 if (NULL == msg)
 {
  fprintf (stderr, "Reply Null\n");
  exit (1);
 }
 // free the pending message handle
 dbus_pending_call_unref (pending);

 // read the parameters
 if (!dbus_message_iter_init (msg, &args))
 {
  fprintf (stderr, "Message has no arguments!\n");
 }
 else if (DBUS_TYPE_DOUBLE != dbus_message_iter_get_arg_type (&args))
 {
  fprintf (stderr, "Argument is not double!\n");
  exit (1);
 }
 else
 {
  dbus_message_iter_get_basic (&args, &result);
 }

 // printf ("Got Reply. Beatfreq: %g\n", result);

 // free reply 
 dbus_message_unref (msg);
 return result;
}

/////////////////////////////////////////
//gets called at the interval set in Glib mainloop set
//in main() via g_timeout_add():
static gboolean access_gnaural_object (gpointer gdec_remote_connection)
{
 gdf_beatfreq = GetBeatfreq ((DBusConnection *) gdec_remote_connection, 0);
 return TRUE;
}

//////////////////////////
DBusConnection *gdec_init_connection (void)
{
 DBusConnection *gdec_remote_connection = NULL;
 DBusError err;
 int ret;

 // initialise the errors
 dbus_error_init (&err);

 // connect to the system bus and check for errors
 gdec_remote_connection = dbus_bus_get (DBUS_BUS_SESSION, &err);
 if (dbus_error_is_set (&err))
 {
  fprintf (stderr, "Connection Error (%s)\n", err.message);
  dbus_error_free (&err);
 }
 if (NULL == gdec_remote_connection)
 {
  return NULL;
  //  exit (1);
 }

 // request our name on the bus
 ret =
  dbus_bus_request_name (gdec_remote_connection, "test.method.caller",
			 DBUS_NAME_FLAG_REPLACE_EXISTING, &err);
 if (dbus_error_is_set (&err))
 {
  fprintf (stderr, "Name Error (%s)\n", err.message);
  dbus_error_free (&err);
 }
 if (DBUS_REQUEST_NAME_REPLY_PRIMARY_OWNER != ret)
 {
  return NULL;
  //  exit (1);
 }
 return gdec_remote_connection;
}

void dbus_start (void)
{
 DBusConnection *gdec_remote_connection = NULL;

 gdec_remote_connection = gdec_init_connection ();

 if (NULL == gdec_remote_connection)
 {
  exit (1);
 }
 g_timeout_add (1000, access_gnaural_object, gdec_remote_connection);
}

//END included from gnaural-dbus-client-example.c:
/////////////////////////////////////////////////
/////////////////////////////////////////////////

////////////////////////////////////////////////
//Following was in main.c, added here to reduce filecount:
// flasherdemo.c -- GdkPixbuf demo */
#include <stdlib.h>
#include <math.h>
#include "gnaural-dbus-flasher.h"
#include <gtk/gtk.h>

//globals:
//////////////////////////////////
flasher_Data *main_FD;

//////////////////////////////////
// standard handlers
gint main_delete_event (GtkWidget * widget, GdkEvent event, gpointer data)
{
 return FALSE;
}

/////////////////////////////
void main_end_program (GtkWidget * widget, gpointer data)
{
 gtk_main_quit ();
}

//////////////////////////////////
gboolean main_ToggleFlasher (gpointer data)
{
 static double old_beatfreq = 1;

 flasher_Render (main_FD);
 // flasher_RenderImage(flasher_Pixbuf);
 // flasher_DisplayImage (main_FD);
 if (0 < gdf_beatfreq && gdf_beatfreq != old_beatfreq)
 {
  unsigned int timeout = (int) (500.0 / gdf_beatfreq);

  g_source_remove (gdf_timeout_id);
  gdf_timeout_id = g_timeout_add (timeout, main_ToggleFlasher, NULL);
  g_print ("Old beat: %ghz New beat: %ghz Delay: %dms\n", old_beatfreq,
	   gdf_beatfreq, timeout);
 }

 old_beatfreq = gdf_beatfreq;
 return TRUE;
}

//////////////////////////////////
int main (int argc, char **argv)
{
 GtkWidget *window;
 GtkHBox *hbox;

 // initialize GTK+, create a window, attach handlers
 gtk_init (&argc, &argv);

 window = gtk_window_new (GTK_WINDOW_TOPLEVEL);
 //gtk_window_fullscreen (GTK_WINDOW(window));

 // create a new HBox, pack the image and vboxes above
 hbox = g_object_new (GTK_TYPE_HBOX, NULL);
 // pack everything into the window, show everything, start GTK+ main loop
 gtk_container_add (GTK_CONTAINER (window), GTK_WIDGET (hbox));

 // attach standard event handlers
 g_signal_connect (window, "delete_event", G_CALLBACK (main_delete_event),
		   NULL);
 g_signal_connect (window, "destroy", G_CALLBACK (main_end_program), NULL);
 gint w = 1,
  h = 1;

 gtk_window_get_size (GTK_WINDOW (window), &w, &h);
 //some color possibilities:
 // main_FD = flasher_Init (w, h, 0xFF0000, 0x0000FF);
 // main_FD = flasher_Init (w, h, 0x8f8f8f, 0x6f6f6f);
 // main_FD = flasher_Init (w, h, 0xFFFF00, 0x00FFFF);
 main_FD = flasher_Init (w, h, 0x111111, 0x00df00);
 gtk_box_pack_start (GTK_BOX (hbox), GTK_WIDGET (main_FD->drawing_area), TRUE,
		     TRUE, 0);
 gtk_widget_show_all (GTK_WIDGET (window));

 //add D-Bus functionality:
 dbus_start ();

 int delay = 1000 / 2;

 //setup the main GUI timer:
 gdf_timeout_id = g_timeout_add (delay, main_ToggleFlasher, NULL);

 gtk_main ();

 g_source_remove (gdf_timeout_id);
 gdf_timeout_id = 0;
 flasher_Cleanup (main_FD);
 return 0;
}

//END included main.c 
/////////////////////////
