#include <sndfile.h>
#include "BinauralBeat.h"

//Typical format types might be:
//SF_FORMAT_WAV
//SF_FORMAT_FLAC
//SF_FORMAT_AIFF
//SF_FORMAT_AU
//SF_FORMAT_RAW
int exportAudioToFile (char *filename, int major_format_type)
{
 const int EA_FRAMES_TO_WRITE = 16;
 const int EA_BYTES_TO_FILL = EA_FRAMES_TO_WRITE * 4;
 SNDFILE *file;
 SF_INFO sfinfo;
 int *buffer[EA_FRAMES_TO_WRITE];

 sfinfo.samplerate = BB_AUDIOSAMPLERATE;
 sfinfo.frames =
  (unsigned int) (BB_Loops * BB_TotalDuration * BB_AUDIOSAMPLERATE + 0.5);
 sfinfo.channels = 2;
 sfinfo.format = (major_format_type | SF_FORMAT_PCM_16);
 sfinfo.sections = 1;
 sfinfo.seekable = 0;

 if (!(file = sf_open (filename, SFM_WRITE, &sfinfo)))
 {
  printf ("Error : Not able to open output file.\n");
  return 1;
 };

 BB_WriteStopFlag = 0;

 BB_Reset ();	//make sure we start at absolute beginning

 while (!(BB_InfoFlag & BB_COMPLETED) && FALSE == BB_WriteStopFlag)
 {
  BB_MainLoop (buffer, EA_BYTES_TO_FILL);
  sf_writef_short (file, (short *) buffer, EA_FRAMES_TO_WRITE);
 }

 sf_close (file);
 return 0;
}
