/***************************************************************************
 * GTKlxsplit                                                              *
 *                                                                         *
 * Copyright (C) 2004 Juan Jose Medina Olarte                              *
 *                                                                         *
 * This program is free software; you can redistribute it and/or modify    *
 * it under the terms of the GNU General Public License as published by    *
 * the Free Software Foundation; either version 2 of the License, or (at   *
 * your option) any later version.                                         *
 *                                                                         *
 * This program is distributed in the hope that it will be useful, but     *
 * WITHOUT ANY WARRANTY; without even the implied warranty of              *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU        *
 * General Public License for more details.                                *
 *                                                                         *
 * You should have received a copy of the GNU General Public License       *
 * along with this program; if not, write to the Free Software             *
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA *
 *                                                                         *
 ***************************************************************************/

#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <string.h>

#include <gdk/gdkkeysyms.h>
#include <gtk/gtk.h>
#include <glib.h>

#include "config.h"
#include "main.h"

static GtkWidget *window = NULL;                                                   
static GtkWidget *vbox1;
static GtkWidget *frame1;
static GtkWidget *vbox2;
static GSList *vbox2_group = NULL;
static GtkWidget *checkbutton1;
static GtkWidget *checkbutton2;
static GtkWidget *checkbutton3;
static GtkWidget *checkbutton4;
static GtkWidget *button1;



static void CloseConfig(GtkWidget *widget, gpointer data)
{
gtk_widget_destroy( GTK_WIDGET (data) );
}


static void ClosingConfig(GtkWidget *widget, gpointer data)
{
gtk_grab_remove( GTK_WIDGET (widget) );
}


static void OptionButtons(GtkWidget *widget, gpointer data)
{
int flagConfig = 1;  // Hubo algun cambio


if(widget == checkbutton1) {
  
   
  if (gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON(checkbutton1)) ) {
     gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON(checkbutton2),  FALSE);
     gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON(checkbutton3),  FALSE);
     gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON(checkbutton4),  FALSE);
     ConfigOption = 1;
  }
      
  return; 
}

if(widget == checkbutton2) {
  
  if (gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON(checkbutton2)) ) {
     gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON(checkbutton1),  FALSE);
     gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON(checkbutton3),  FALSE);
     gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON(checkbutton4),  FALSE);
     ConfigOption = 2;
  }
  
  
  return;
}

if(widget == checkbutton3) {
  
  if (gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON(checkbutton3)) ) {
     gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON(checkbutton2),  FALSE);
     gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON(checkbutton1),  FALSE);
     gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON(checkbutton4),  FALSE);
     ConfigOption = 3;
  }
  
  
  return;
}


if(widget == checkbutton4) {
  
  if (gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON(checkbutton4)) ) {
     gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON(checkbutton2),  FALSE);
     gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON(checkbutton1),  FALSE);
     gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON(checkbutton3),  FALSE);
     ConfigOption = 4;
  }
  
  
  return;
}


}


void Configuration()
{
window = gtk_window_new (GTK_WINDOW_DIALOG);
gtk_window_set_title (GTK_WINDOW (window), "Quick configuration");
gtk_window_set_position (GTK_WINDOW (window), GTK_WIN_POS_MOUSE);
gtk_signal_connect (GTK_OBJECT (window), "destroy", GTK_SIGNAL_FUNC(ClosingConfig), &window);

vbox1 = gtk_vbox_new (FALSE, 0);
gtk_widget_ref (vbox1);
gtk_object_set_data_full (GTK_OBJECT(window), "vbox1", vbox1,
                            (GtkDestroyNotify) gtk_widget_unref);
gtk_widget_show (vbox1);
gtk_container_add (GTK_CONTAINER (window), vbox1);

frame1 = gtk_frame_new ("lxsplit binary location");
gtk_widget_ref (frame1);
gtk_object_set_data_full (GTK_OBJECT (window), "frame1", frame1,
                            (GtkDestroyNotify) gtk_widget_unref);
gtk_widget_show (frame1);
gtk_box_pack_start (GTK_BOX (vbox1), frame1, FALSE, TRUE, 0);
gtk_container_set_border_width (GTK_CONTAINER (frame1), 5);
gtk_frame_set_shadow_type (GTK_FRAME (frame1), GTK_SHADOW_ETCHED_OUT);

vbox2 = gtk_vbox_new (FALSE, 0);
gtk_widget_ref (vbox2);
gtk_object_set_data_full (GTK_OBJECT (window), "vbox2", vbox2,
                            (GtkDestroyNotify) gtk_widget_unref);
gtk_widget_show (vbox2);
gtk_container_add (GTK_CONTAINER (frame1), vbox2);

checkbutton1 = gtk_check_button_new_with_label ("Default system path($PATH)");
gtk_widget_ref (checkbutton1);
gtk_object_set_data_full (GTK_OBJECT (window), "checkbutton1", checkbutton1,
                            (GtkDestroyNotify) gtk_widget_unref);
gtk_signal_connect (GTK_OBJECT (checkbutton1), "clicked", GTK_SIGNAL_FUNC(OptionButtons), NULL);
gtk_widget_show (checkbutton1);
gtk_box_pack_start (GTK_BOX (vbox2), checkbutton1, FALSE, FALSE, 5);
gtk_container_set_border_width (GTK_CONTAINER (checkbutton1), 5);

checkbutton2 = gtk_check_button_new_with_label ("Home directory ($HOME)");
gtk_widget_ref (checkbutton2);
gtk_object_set_data_full (GTK_OBJECT (window), "checkbutton2", checkbutton2,
                            (GtkDestroyNotify) gtk_widget_unref);
gtk_signal_connect (GTK_OBJECT (checkbutton2), "clicked", GTK_SIGNAL_FUNC(OptionButtons), NULL);
gtk_widget_show (checkbutton2);
gtk_box_pack_start (GTK_BOX (vbox2), checkbutton2, FALSE, FALSE, 5);
gtk_container_set_border_width (GTK_CONTAINER (checkbutton2), 5);

checkbutton3 = gtk_check_button_new_with_label ("Binary home directory ($HOME/bin)");
gtk_widget_ref (checkbutton3);
gtk_object_set_data_full (GTK_OBJECT (window), "checkbutton3", checkbutton3,
                            (GtkDestroyNotify) gtk_widget_unref);
gtk_signal_connect (GTK_OBJECT (checkbutton3), "clicked", GTK_SIGNAL_FUNC(OptionButtons), NULL);
gtk_widget_show (checkbutton3);
gtk_box_pack_start (GTK_BOX (vbox2), checkbutton3, FALSE, FALSE, 5);
gtk_container_set_border_width (GTK_CONTAINER (checkbutton3), 5);

checkbutton4 = gtk_check_button_new_with_label ("Current directory (./)");
gtk_widget_ref (checkbutton4);
gtk_object_set_data_full (GTK_OBJECT (window), "checkbutton4", checkbutton4,
                            (GtkDestroyNotify) gtk_widget_unref);
gtk_signal_connect (GTK_OBJECT (checkbutton4), "clicked", GTK_SIGNAL_FUNC(OptionButtons), NULL);
gtk_widget_show (checkbutton4);
gtk_box_pack_start (GTK_BOX (vbox2), checkbutton4, FALSE, FALSE, 5);
gtk_container_set_border_width (GTK_CONTAINER (checkbutton4), 5);



button1 = gtk_button_new_with_label ("Close");
gtk_widget_ref (button1);
gtk_object_set_data_full (GTK_OBJECT (window), "button1", button1,
                            (GtkDestroyNotify) gtk_widget_unref);
  
GTK_WIDGET_SET_FLAGS(button1, GTK_CAN_DEFAULT);
  
gtk_box_pack_start (GTK_BOX (vbox1), button1, FALSE, FALSE, 0);
gtk_container_set_border_width (GTK_CONTAINER (button1), 5);
gtk_signal_connect (GTK_OBJECT (button1), "clicked", GTK_SIGNAL_FUNC(CloseConfig), window);
gtk_widget_show (button1);
gtk_widget_show (window);


if(ConfigOption == 1)
 gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(checkbutton1),  TRUE);

if(ConfigOption == 2)
 gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(checkbutton2),  TRUE);

if(ConfigOption == 3)
 gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(checkbutton3),  TRUE);

if(ConfigOption == 4)
 gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(checkbutton4),  TRUE);

  
gtk_grab_add(window);
gtk_widget_grab_default (button1);

}
