/***************************************************************************
 * GTKlxsplit                                                              *
 *                                                                         *
 * Copyright (C) 2004 Juan Jose Medina Olarte                              *
 *                                                                         *
 * This program is free software; you can redistribute it and/or modify    *
 * it under the terms of the GNU General Public License as published by    *
 * the Free Software Foundation; either version 2 of the License, or (at   *
 * your option) any later version.                                         *
 *                                                                         *
 * This program is distributed in the hope that it will be useful, but     *
 * WITHOUT ANY WARRANTY; without even the implied warranty of              *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU        *
 * General Public License for more details.                                *
 *                                                                         *
 * You should have received a copy of the GNU General Public License       *
 * along with this program; if not, write to the Free Software             *
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA *
 *                                                                         *
 ***************************************************************************/

#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <string.h>
#include <stdio.h>

#include <gdk/gdkkeysyms.h>
#include <gtk/gtk.h>

#include "split.h"
#include "join.h"
#include "config.h"
#include "about.h"
#include "main.h"
#include "gtkinterface.h"

char *welcome = "GTKlxsplit version 0.1.1\n(graphical interface for the 'lxsplit' program)\n\n";


GtkWidget *window1;
static GtkWidget *vbox1;
static GtkWidget *hbox1;
static GtkWidget *button1;
static GtkWidget *button2;
static GtkWidget *hbox2;
static GtkWidget *button3;
static GtkWidget *button4;
static GtkWidget *hseparator1;
static GtkWidget *scrolledwindow1;
GtkWidget *text1;
static GtkWidget *button5;


void CloseApplication(GtkWidget *widget, gpointer data)
{
unlink(logfile);
gtk_main_quit();
}


void CreateMain()
{
  window1 = gtk_window_new (GTK_WINDOW_TOPLEVEL);
  gtk_object_set_data (GTK_OBJECT (window1), "window1", window1);
  gtk_window_set_title (GTK_WINDOW (window1),  PROGRAM_NAME);
  gtk_window_set_position (GTK_WINDOW (window1), GTK_WIN_POS_CENTER);
  gtk_window_set_default_size (GTK_WINDOW (window1), 450, 350);

  vbox1 = gtk_vbox_new (FALSE, 0);
  gtk_widget_ref (vbox1);
  gtk_object_set_data_full (GTK_OBJECT (window1), "vbox1", vbox1,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (vbox1);
  gtk_container_add (GTK_CONTAINER (window1), vbox1);

  hbox1 = gtk_hbox_new (FALSE, 0);
  gtk_widget_ref (hbox1);
  gtk_object_set_data_full (GTK_OBJECT (window1), "hbox1", hbox1,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (hbox1);
  gtk_box_pack_start (GTK_BOX (vbox1), hbox1, TRUE, TRUE, 0);

  button1 = gtk_button_new_with_label ("     Split      ");
  gtk_widget_ref (button1);
  gtk_object_set_data_full (GTK_OBJECT (window1), "button1", button1,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_signal_connect (GTK_OBJECT (button1), "clicked", GTK_SIGNAL_FUNC(Split), NULL);
  gtk_widget_show (button1);
  gtk_box_pack_start (GTK_BOX (hbox1), button1, TRUE, TRUE, 0);
  gtk_container_set_border_width (GTK_CONTAINER (button1), 5);

  button2 = gtk_button_new_with_label ("    Join     ");
  gtk_widget_ref (button2);
  gtk_object_set_data_full (GTK_OBJECT (window1), "button2", button2,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_signal_connect (GTK_OBJECT (button2), "clicked", GTK_SIGNAL_FUNC(Join), NULL);
  gtk_widget_show (button2);
  gtk_box_pack_start (GTK_BOX (hbox1), button2, TRUE, TRUE, 0);
  gtk_container_set_border_width (GTK_CONTAINER (button2), 5);

  hbox2 = gtk_hbox_new (FALSE, 0);
  gtk_widget_ref (hbox2);
  gtk_object_set_data_full (GTK_OBJECT (window1), "hbox2", hbox2,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (hbox2);
  gtk_box_pack_start (GTK_BOX (vbox1), hbox2, TRUE, TRUE, 0);

  button3 = gtk_button_new_with_label ("Configuration");
  gtk_widget_ref (button3);
  gtk_object_set_data_full (GTK_OBJECT (window1), "button3", button3,
                            (GtkDestroyNotify) gtk_widget_unref);
  
  gtk_signal_connect (GTK_OBJECT (button3), "clicked", GTK_SIGNAL_FUNC(Configuration), NULL);
  gtk_widget_show (button3);
  gtk_box_pack_start (GTK_BOX (hbox2), button3, TRUE, TRUE, 0);
  gtk_container_set_border_width (GTK_CONTAINER (button3), 5);

  button4 = gtk_button_new_with_label ("  About...   ");
  gtk_widget_ref (button4);
  gtk_object_set_data_full (GTK_OBJECT (window1), "button4", button4,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_signal_connect (GTK_OBJECT (button4), "clicked", GTK_SIGNAL_FUNC(About), NULL);
  gtk_widget_show (button4);
  gtk_box_pack_start (GTK_BOX (hbox2), button4, TRUE, TRUE, 0);
  gtk_container_set_border_width (GTK_CONTAINER (button4), 5);

  hseparator1 = gtk_hseparator_new ();
  gtk_widget_ref (hseparator1);
  gtk_object_set_data_full (GTK_OBJECT (window1), "hseparator1", hseparator1,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (hseparator1);
  gtk_box_pack_start (GTK_BOX (vbox1), hseparator1, FALSE, FALSE, 0);

  scrolledwindow1 = gtk_scrolled_window_new (NULL, NULL);
  gtk_widget_ref (scrolledwindow1);
  gtk_object_set_data_full (GTK_OBJECT (window1), "scrolledwindow1", scrolledwindow1,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (scrolledwindow1);
  gtk_box_pack_start (GTK_BOX (vbox1), scrolledwindow1, TRUE, TRUE, 0);
  gtk_container_set_border_width (GTK_CONTAINER (scrolledwindow1), 5);
  gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scrolledwindow1), 
  									GTK_POLICY_NEVER, GTK_POLICY_ALWAYS);

  text1 = gtk_text_new (NULL, NULL);
  gtk_widget_ref (text1);
  gtk_object_set_data_full (GTK_OBJECT (window1), "text1", text1,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (text1);
  gtk_text_set_editable( GTK_TEXT(text1), FALSE );
  gtk_container_add (GTK_CONTAINER (scrolledwindow1), text1);

  gtk_text_insert(GTK_TEXT(text1), NULL, NULL, NULL, welcome, strlen(welcome));

  button5 = gtk_button_new_with_label ("Close GTK-lxsplit");
  gtk_widget_ref (button5);
  gtk_object_set_data_full (GTK_OBJECT (window1), "button5", button5,
                            (GtkDestroyNotify) gtk_widget_unref);
  
  gtk_signal_connect (GTK_OBJECT (button5), "clicked",
                                       GTK_SIGNAL_FUNC (CloseApplication), NULL);
  gtk_widget_show (button5);
  gtk_box_pack_start (GTK_BOX (vbox1), button5, FALSE, FALSE, 0);
  gtk_container_set_border_width (GTK_CONTAINER (button5), 5);

  gtk_signal_connect (GTK_OBJECT (window1), "delete_event",
                                       GTK_SIGNAL_FUNC (CloseApplication), NULL);

gtk_widget_show (window1);

}


#define BUF_SIZE  512

/* Show the logfile */

void ShowLogFile()
{
FILE *infile;
int nchars;
char buffer[BUF_SIZE];

gtk_text_freeze( GTK_TEXT(text1));

infile = fopen(logfile, "r");

if (logfile) {

 while(( nchars = fread(buffer, 1, BUF_SIZE, infile)) > 0) {
 
    gtk_text_insert(GTK_TEXT(text1), NULL, NULL, NULL, buffer, nchars);
    
    if(nchars < BUF_SIZE)
      break;

 }

fclose(infile);
}

gtk_text_thaw(GTK_TEXT(text1));

}






