/***************************************************************************
 * GTKlxsplit                                                              *
 *                                                                         *
 * Copyright (C) 2004 Juan Jose Medina Olarte                              *
 *                                                                         *
 * This program is free software; you can redistribute it and/or modify    *
 * it under the terms of the GNU General Public License as published by    *
 * the Free Software Foundation; either version 2 of the License, or (at   *
 * your option) any later version.                                         *
 *                                                                         *
 * This program is distributed in the hope that it will be useful, but     *
 * WITHOUT ANY WARRANTY; without even the implied warranty of              *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU        *
 * General Public License for more details.                                *
 *                                                                         *
 * You should have received a copy of the GNU General Public License       *
 * along with this program; if not, write to the Free Software             *
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA *
 *                                                                         *
 ***************************************************************************/


#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <string.h>
#include <stdio.h>
#include <stdlib.h>

#include <gdk/gdkkeysyms.h>
#include <gtk/gtk.h>
#include <glib.h>

#include "gtkinterface.h"
#include "location.h"
#include "join.h"
#include "main.h"

gchar* joinmess = "To join a set of files, please first\nopen the .001 file using the 'Input\nFile' button. If the other files (.002,\n.003, etc.) are in the same directory\nthey will be found automatically.";

static char *mess2 = "No file selected, try again!\n";
static char *mess3 = "Join: Wait, lxsplit working  . . .\n\n";
static char *mess4 = "\nJoin: Done!\n";

static char command[2048];  // Overflow ??? I don't think so

static GtkWidget *window3;
static GtkWidget *vbox1;
static GtkWidget *hbox1;
static GtkWidget *button1;
static GtkWidget *entry2;
static GtkWidget *hbox5;
static GtkWidget *label2;
static GtkWidget *button2;
static GtkWidget *button3;

static char *filename = NULL;

static void initjoin(GtkWidget *widget, gpointer data)
{

filename = gtk_entry_get_text( GTK_ENTRY(entry2));

if(strlen(filename) < 1) {  // if no select file name 

 gtk_text_insert(GTK_TEXT(text1), NULL, NULL, NULL, mess2, strlen(mess2));
 gtk_widget_destroy( GTK_WIDGET (data) );
 return;
}

getnewlxsplitlocation();  // Update lxsplit path searching

// create the command string

memset(command, 0, 2048);
sprintf(command, "%s -j %s > %s", lxsplit_str, filename, logfile);

// destroy current dialog

gtk_text_insert(GTK_TEXT(text1), NULL, NULL, NULL, mess3, strlen(mess3));
gtk_widget_destroy( GTK_WIDGET (data) );

// prepare all widgets
gtk_grab_add(window1);

// execute the lxsplit program
system(command);

// restore all widgets

gtk_grab_remove(window1);

// show into the console the logfile

ShowLogFile();
gtk_text_insert(GTK_TEXT(text1), NULL, NULL, NULL, mess4, strlen(mess4));

}



static void CloseConfig(GtkWidget *widget, gpointer data)
{
gtk_widget_destroy( GTK_WIDGET (data) );
}


static void ClosingConfig(GtkWidget *widget, gpointer data)
{
gtk_grab_remove( GTK_WIDGET (widget) );
}


/* Selection file */

static void destroyfilesel( GtkWidget *widget, gpointer   data )
{
gtk_grab_remove( GTK_WIDGET (widget) );    
}


static void file_ok_sel( GtkWidget *w, GtkFileSelection *fs )
{
gchar *tmp = NULL;
tmp = gtk_file_selection_get_filename (GTK_FILE_SELECTION (fs));

// save string into gtk_entry widget
gtk_entry_set_text( GTK_ENTRY(entry2), tmp);

gtk_widget_destroy(GTK_WIDGET(fs));
}


static void selectfile(GtkWidget *widget, gpointer data)
{
GtkWidget *filew;

 /* Create a new file selection widget */
    filew = gtk_file_selection_new ("File selection");
    
    gtk_signal_connect (GTK_OBJECT (filew), "destroy", (GtkSignalFunc) destroyfilesel, &filew);

    /* Connect the ok_button to file_ok_sel function */
    gtk_signal_connect (GTK_OBJECT (GTK_FILE_SELECTION (filew)->ok_button),
			"clicked", (GtkSignalFunc) file_ok_sel, filew );
    
    /* Connect the cancel_button to destroy the widget */
    gtk_signal_connect_object (GTK_OBJECT (GTK_FILE_SELECTION
                                            (filew)->cancel_button),
			       "clicked", (GtkSignalFunc) gtk_widget_destroy,
			       GTK_OBJECT (filew));

    gtk_widget_show(filew);
    gtk_grab_add(filew);
    
} 


void Join()
{
  window3 = gtk_window_new (GTK_WINDOW_DIALOG);
  gtk_object_set_data (GTK_OBJECT (window3), "window3", window3);
  gtk_window_set_title (GTK_WINDOW (window3),  "Join");
  gtk_signal_connect (GTK_OBJECT (window3), "destroy", GTK_SIGNAL_FUNC(ClosingConfig), &window3);
  gtk_window_set_position (GTK_WINDOW (window3), GTK_WIN_POS_MOUSE);

  vbox1 = gtk_vbox_new (FALSE, 0);
  gtk_widget_ref (vbox1);
  gtk_object_set_data_full (GTK_OBJECT (window3), "vbox1", vbox1,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (vbox1);
  gtk_container_add (GTK_CONTAINER (window3), vbox1);

  hbox1 = gtk_hbox_new (FALSE, 0);
  gtk_widget_ref (hbox1);
  gtk_object_set_data_full (GTK_OBJECT (window3), "hbox1", hbox1,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (hbox1);
  gtk_box_pack_start (GTK_BOX (vbox1), hbox1, FALSE, FALSE, 5);

  button1 = gtk_button_new_with_label ("Input File");
  gtk_widget_ref (button1);
  gtk_object_set_data_full (GTK_OBJECT (window3), "button1", button1,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_signal_connect (GTK_OBJECT (button1), "clicked", GTK_SIGNAL_FUNC(selectfile), NULL);
  gtk_widget_show (button1);
  gtk_box_pack_start (GTK_BOX (hbox1), button1, FALSE, FALSE, 5);
  gtk_container_set_border_width (GTK_CONTAINER (button1), 5);

  entry2 = gtk_entry_new_with_max_length (1024);
  gtk_widget_ref (entry2);
  gtk_object_set_data_full (GTK_OBJECT (window3), "entry2", entry2,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (entry2);
  gtk_box_pack_start (GTK_BOX (hbox1), entry2, TRUE, TRUE, 5);
  gtk_widget_set_usize (entry2, 300, -2);

  hbox5 = gtk_hbox_new (FALSE, 0);
  gtk_widget_ref (hbox5);
  gtk_object_set_data_full (GTK_OBJECT (window3), "hbox5", hbox5,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (hbox5);
  gtk_box_pack_start (GTK_BOX (vbox1), hbox5, FALSE, FALSE, 0);

  label2 = gtk_label_new (joinmess);
  gtk_widget_ref (label2);
  gtk_object_set_data_full (GTK_OBJECT (window3), "label2", label2,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (label2);
  gtk_box_pack_start (GTK_BOX (hbox5), label2, FALSE, FALSE, 10);

  button2 = gtk_button_new_with_label ("Start");
  gtk_widget_ref (button2);
  gtk_object_set_data_full (GTK_OBJECT (window3), "button2", button2,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_signal_connect (GTK_OBJECT (button2), "clicked", GTK_SIGNAL_FUNC(initjoin), window3);
  gtk_widget_show (button2);
  gtk_box_pack_start (GTK_BOX (hbox5), button2, TRUE, TRUE, 0);
  gtk_container_set_border_width (GTK_CONTAINER (button2), 5);

  button3 = gtk_button_new_with_label ("Close");
  gtk_widget_ref (button3);
  gtk_object_set_data_full (GTK_OBJECT (window3), "button3", button3,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_signal_connect (GTK_OBJECT (button3), "clicked", GTK_SIGNAL_FUNC(CloseConfig), window3);
  gtk_widget_show (button3);
  gtk_box_pack_start (GTK_BOX (hbox5), button3, TRUE, TRUE, 0);
  gtk_container_set_border_width (GTK_CONTAINER (button3), 5);

  gtk_widget_show (window3);
  gtk_grab_add(window3);

}


