/***************************************************************************
 * GTKlxsplit                                                              *
 *                                                                         *
 * Copyright (C) 2004 Juan Jose Medina Olarte                              *
 *                                                                         *
 * This program is free software; you can redistribute it and/or modify    *
 * it under the terms of the GNU General Public License as published by    *
 * the Free Software Foundation; either version 2 of the License, or (at   *
 * your option) any later version.                                         *
 *                                                                         *
 * This program is distributed in the hope that it will be useful, but     *
 * WITHOUT ANY WARRANTY; without even the implied warranty of              *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU        *
 * General Public License for more details.                                *
 *                                                                         *
 * You should have received a copy of the GNU General Public License       *
 * along with this program; if not, write to the Free Software             *
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA *
 *                                                                         *
 ***************************************************************************/

#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <string.h>
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <sys/wait.h>
#include <pwd.h>

#include "main.h"


char *getHomePath(char *str)
{
char *home_path = getenv("HOME");
struct passwd *passwd;
int user_id;

if(home_path) {
  strcpy(str, home_path);
}  
else {
  
  if((home_path = getenv("USER")) != NULL) {  
     passwd = getpwnam(home_path);
  } 
  else { 
    user_id = getuid();  
    passwd  = getpwuid(user_id);
  }
   
  if(passwd) {
    strcpy(str, passwd->pw_dir);
  }
  else {
    *str = ' ';
  }

}

return str;
}



/* return the string location for lxsplit program */

void getnewlxsplitlocation()
{

// If some change has been detected . . .
if( (flagConfig == 1) || (lxsplit_str == NULL) ) {
 
 if(flagConfig > 0)
  flagConfig = 0;
 
 if(lxsplit_str)
   free(lxsplit_str);
 
   
 switch(ConfigOption) {

	case 1:
	  lxsplit_str = (char *)malloc(sizeof(char) * 10);
	  strcpy(lxsplit_str, "lxsplit");
	break;

	case 2:
	{  
	 char home[1024];
	 int len = 0;
	 
	  (void) getHomePath(home);
	  len = strlen(home);
	  
	  if(len > 1) {
	   lxsplit_str = (char *)malloc(sizeof(char) * (len + 12));
	   strcpy(lxsplit_str, home);
	   strcat(lxsplit_str, "/lxsplit");
	  }
	  else {  // default
	   lxsplit_str = (char *)malloc(sizeof(char) * 10);
	   strcpy(lxsplit_str, "lxsplit");
	  }
	 	 
	} 
	break;

	case 3:
	{  
	 char home[1024];
	 int len = 0;
	 
	  (void) getHomePath(home);
	  len = strlen(home);
	 
	  if(len > 1) {
	   lxsplit_str = (char *)malloc(sizeof(char) * (len + 18));
	   strcpy(lxsplit_str, home);
	   strcat(lxsplit_str, "/bin/lxsplit");
	  }
	  else {  // default
	   lxsplit_str = (char *)malloc(sizeof(char) * 10);
	   strcpy(lxsplit_str, "lxsplit");
	  }
	 	 
	}
	break;

	case 4:
	  lxsplit_str = (char *)malloc(sizeof(char) * 12);
	  strcpy(lxsplit_str, "./lxsplit");
	break;

        }    

}


}


