/***************************************************************************
 * GTKlxsplit                                                              *
 *                                                                         *
 * Copyright (C) 2004 Juan Jose Medina Olarte                              *
 *                                                                         *
 * This program is free software; you can redistribute it and/or modify    *
 * it under the terms of the GNU General Public License as published by    *
 * the Free Software Foundation; either version 2 of the License, or (at   *
 * your option) any later version.                                         *
 *                                                                         *
 * This program is distributed in the hope that it will be useful, but     *
 * WITHOUT ANY WARRANTY; without even the implied warranty of              *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU        *
 * General Public License for more details.                                *
 *                                                                         *
 * You should have received a copy of the GNU General Public License       *
 * along with this program; if not, write to the Free Software             *
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA *
 *                                                                         *
 ***************************************************************************/

#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <string.h>
#include <stdio.h>
#include <stdlib.h>

#include <gdk/gdkkeysyms.h>
#include <gtk/gtk.h>
#include <glib.h>

#include "gtkinterface.h"
#include "location.h"
#include "split.h"
#include "main.h"

gchar* mess = "To split a file, please first open the\ninput file with the 'Input file'\nbutton. After pressing 'Start', the\noutput (split) files will be put into\nthe same directory as the input file.";

static char *mess2 = "No file selected, try again!\n";
static char *mess3 = "Split: Wait, lxsplit working  . . .\n\n";
static char *mess4 = "\nSplit: Done!\n";

char command[2048];  // Overflow ??? I don't think so

static GtkWidget *window2;
static GtkWidget *vbox1;
static GtkWidget *hbox1;
static GtkWidget *label1;
static GtkWidget *hbox2;
static GtkWidget *button1;
static GtkWidget *entry1;
static GtkWidget *hbox3;
static GtkWidget *label2;
static GtkWidget *entry2;
static GtkWidget *checkbutton1;
static GtkWidget *checkbutton2;
static GtkWidget *checkbutton3;
static GtkWidget *hbox4;
static GtkWidget *label3;
static GtkWidget *button2;
static GtkWidget *button3;

char *filename = NULL;
char *splitsize = NULL;


static void initsplit(GtkWidget *widget, gpointer data)
{
char *size_tmp = gtk_entry_get_text( GTK_ENTRY(entry2));
int len = 0;
char bytes = 'k';

filename = gtk_entry_get_text( GTK_ENTRY(entry1));

if(strlen(filename) < 1) {  // if no select file name 

 gtk_text_insert(GTK_TEXT(text1), NULL, NULL, NULL, mess2, strlen(mess2));
 gtk_widget_destroy( GTK_WIDGET (data) );
 return;
}

// Prepare some values

len = strlen(size_tmp);
splitsize = (char *)g_malloc(sizeof(char) * len + 2);

if(SplitOption == 1)
 bytes = 'M';

if(SplitOption == 2)
 bytes = 'k';

if(SplitOption == 3)
 bytes = 'b';

sprintf(splitsize, "%s%c", size_tmp, bytes);

getnewlxsplitlocation();  // Update lxsplit path searching

// create the command string

memset(command, 0, 2048);
sprintf(command, "%s -s %s %s > %s", lxsplit_str, filename, splitsize, logfile);

// destroy current dialog

gtk_text_insert(GTK_TEXT(text1), NULL, NULL, NULL, mess3, strlen(mess3));
gtk_widget_destroy( GTK_WIDGET (data) );

// prepare all widgets
gtk_grab_add(window1);

// execute the lxsplit program
system(command);

// restore all widgets

gtk_grab_remove(window1);

// show into the console the logfile

ShowLogFile();
gtk_text_insert(GTK_TEXT(text1), NULL, NULL, NULL, mess4, strlen(mess4));

// free all

g_free(splitsize);
}



static void CloseConfig(GtkWidget *widget, gpointer data)
{
gtk_widget_destroy( GTK_WIDGET (data) );
}


static void ClosingConfig(GtkWidget *widget, gpointer data)
{
gtk_grab_remove( GTK_WIDGET (widget) );
}



static void OptionButtons(GtkWidget *widget, gpointer data)
{

if(widget == checkbutton1) {
  
   
  if (gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON(checkbutton1)) ) {
     gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON(checkbutton2),  FALSE);
     gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON(checkbutton3),  FALSE);
     SplitOption = 1;
  }
      
  return; 
}

if(widget == checkbutton2) {
  
  if (gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON(checkbutton2)) ) {
     gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON(checkbutton1),  FALSE);
     gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON(checkbutton3),  FALSE);
     SplitOption = 2;
  }
  
  
  return;
}

if(widget == checkbutton3) {
  
  if (gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON(checkbutton3)) ) {
     gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON(checkbutton2),  FALSE);
     gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON(checkbutton1),  FALSE);
     SplitOption = 3;
  }
  
  
  return;
}

}


/* Selection file */

void destroyfilesel( GtkWidget *widget, gpointer   data )
{
gtk_grab_remove( GTK_WIDGET (widget) );    
}


void file_ok_sel( GtkWidget *w, GtkFileSelection *fs )
{
gchar *tmp = NULL;
tmp = gtk_file_selection_get_filename (GTK_FILE_SELECTION (fs));

// save string into gtk_entry widget
gtk_entry_set_text( GTK_ENTRY(entry1), tmp);

gtk_widget_destroy(GTK_WIDGET(fs));
}


void selectfile(GtkWidget *widget, gpointer data)
{
GtkWidget *filew;

 /* Create a new file selection widget */
    filew = gtk_file_selection_new ("File selection");
    
    gtk_signal_connect (GTK_OBJECT (filew), "destroy", (GtkSignalFunc) destroyfilesel, &filew);

    /* Connect the ok_button to file_ok_sel function */
    gtk_signal_connect (GTK_OBJECT (GTK_FILE_SELECTION (filew)->ok_button),
			"clicked", (GtkSignalFunc) file_ok_sel, filew );
    
    /* Connect the cancel_button to destroy the widget */
    gtk_signal_connect_object (GTK_OBJECT (GTK_FILE_SELECTION
                                            (filew)->cancel_button),
			       "clicked", (GtkSignalFunc) gtk_widget_destroy,
			       GTK_OBJECT (filew));

    gtk_widget_show(filew);
    gtk_grab_add(filew);
    
} 



void Split()
{
  window2 = gtk_window_new (GTK_WINDOW_DIALOG);
  gtk_object_set_data (GTK_OBJECT (window2), "window2", window2);
  gtk_window_set_title (GTK_WINDOW (window2), "Split");
  gtk_window_set_position (GTK_WINDOW (window2), GTK_WIN_POS_MOUSE);
  gtk_signal_connect (GTK_OBJECT (window2), "destroy", GTK_SIGNAL_FUNC(ClosingConfig), &window2);


  vbox1 = gtk_vbox_new (FALSE, 0);
  gtk_widget_ref (vbox1);
  gtk_object_set_data_full (GTK_OBJECT (window2), "vbox1", vbox1,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (vbox1);
  gtk_container_add (GTK_CONTAINER (window2), vbox1);

  hbox1 = gtk_hbox_new (FALSE, 0);
  gtk_widget_ref (hbox1);
  gtk_object_set_data_full (GTK_OBJECT (window2), "hbox1", hbox1,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (hbox1);
  gtk_box_pack_start (GTK_BOX (vbox1), hbox1, FALSE, FALSE, 5);

  label1 = gtk_label_new ("File Split");
  gtk_widget_ref (label1);
  gtk_object_set_data_full (GTK_OBJECT (window2), "label1", label1,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (label1);
  gtk_box_pack_start (GTK_BOX (hbox1), label1, FALSE, FALSE, 5);

  hbox2 = gtk_hbox_new (FALSE, 0);
  gtk_widget_ref (hbox2);
  gtk_object_set_data_full (GTK_OBJECT (window2), "hbox2", hbox2,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (hbox2);
  gtk_box_pack_start (GTK_BOX (vbox1), hbox2, FALSE, FALSE, 5);

  button1 = gtk_button_new_with_label ("Input File");
  gtk_widget_ref (button1);
  gtk_object_set_data_full (GTK_OBJECT (window2), "button1", button1,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_signal_connect (GTK_OBJECT (button1), "clicked", GTK_SIGNAL_FUNC(selectfile), NULL);
  gtk_widget_show (button1);
  gtk_box_pack_start (GTK_BOX (hbox2), button1, FALSE, FALSE, 0);
  gtk_container_set_border_width (GTK_CONTAINER (button1), 5);

  entry1 = gtk_entry_new_with_max_length(1024);
  gtk_widget_ref (entry1);
  gtk_object_set_data_full (GTK_OBJECT (window2), "entry1", entry1,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (entry1);
  gtk_box_pack_start (GTK_BOX (hbox2), entry1, TRUE, TRUE, 5);

  hbox3 = gtk_hbox_new (FALSE, 0);
  gtk_widget_ref (hbox3);
  gtk_object_set_data_full (GTK_OBJECT (window2), "hbox3", hbox3,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (hbox3);
  gtk_box_pack_start (GTK_BOX (vbox1), hbox3, FALSE, FALSE, 5);

  label2 = gtk_label_new ("Split File Size");
  gtk_widget_ref (label2);
  gtk_object_set_data_full (GTK_OBJECT (window2), "label2", label2,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (label2);
  gtk_box_pack_start (GTK_BOX (hbox3), label2, FALSE, FALSE, 5);

  entry2 = gtk_entry_new_with_max_length(20);
  gtk_widget_ref (entry2);
  gtk_object_set_data_full (GTK_OBJECT (window2), "entry2", entry2,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_entry_set_text(GTK_ENTRY(entry2), "1400");
  gtk_widget_show (entry2);
  gtk_box_pack_start (GTK_BOX (hbox3), entry2, FALSE, FALSE, 5);

  checkbutton1 = gtk_check_button_new_with_label ("Mbytes");
  gtk_widget_ref (checkbutton1);
  gtk_object_set_data_full (GTK_OBJECT (window2), "checkbutton1", checkbutton1,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_signal_connect (GTK_OBJECT (checkbutton1), "clicked", GTK_SIGNAL_FUNC(OptionButtons), NULL);
  gtk_widget_show (checkbutton1);
  gtk_box_pack_start (GTK_BOX (hbox3), checkbutton1, FALSE, FALSE, 0);

  checkbutton2 = gtk_check_button_new_with_label ("Kbytes");
  gtk_widget_ref (checkbutton2);
  gtk_object_set_data_full (GTK_OBJECT (window2), "checkbutton2", checkbutton2,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_signal_connect (GTK_OBJECT (checkbutton2), "clicked", GTK_SIGNAL_FUNC(OptionButtons), NULL);
  gtk_widget_show (checkbutton2);
  gtk_box_pack_start (GTK_BOX (hbox3), checkbutton2, FALSE, FALSE, 0);

  checkbutton3 = gtk_check_button_new_with_label ("Bytes");
  gtk_widget_ref (checkbutton3);
  gtk_object_set_data_full (GTK_OBJECT (window2), "checkbutton3", checkbutton3,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_signal_connect (GTK_OBJECT (checkbutton3), "clicked", GTK_SIGNAL_FUNC(OptionButtons), NULL);
  gtk_widget_show (checkbutton3);
  gtk_box_pack_start (GTK_BOX (hbox3), checkbutton3, FALSE, FALSE, 0);

  hbox4 = gtk_hbox_new (FALSE, 0);
  gtk_widget_ref (hbox4);
  gtk_object_set_data_full (GTK_OBJECT (window2), "hbox4", hbox4,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (hbox4);
  gtk_box_pack_start (GTK_BOX (vbox1), hbox4, FALSE, FALSE, 5);

  label3 = gtk_label_new (mess);
  gtk_widget_ref (label3);
  gtk_object_set_data_full (GTK_OBJECT (window2), "label3", label3,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (label3);
  gtk_box_pack_start (GTK_BOX (hbox4), label3, FALSE, FALSE, 5);

  button2 = gtk_button_new_with_label ("Start");
  gtk_widget_ref (button2);
  gtk_object_set_data_full (GTK_OBJECT (window2), "button2", button2,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_signal_connect (GTK_OBJECT (button2), "clicked", GTK_SIGNAL_FUNC(initsplit), window2);
  gtk_widget_show (button2);
  gtk_box_pack_start (GTK_BOX (hbox4), button2, TRUE, TRUE, 0);
  gtk_container_set_border_width (GTK_CONTAINER (button2), 10);

  button3 = gtk_button_new_with_label ("Close");
  gtk_widget_ref (button3);
  gtk_object_set_data_full (GTK_OBJECT (window2), "button3", button3,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_signal_connect (GTK_OBJECT (button3), "clicked", GTK_SIGNAL_FUNC(CloseConfig), window2);
  gtk_widget_show (button3);
  gtk_box_pack_start (GTK_BOX (hbox4), button3, TRUE, TRUE, 0);
  gtk_container_set_border_width (GTK_CONTAINER (button3), 9);

  gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON(checkbutton2),  TRUE);

  gtk_widget_show (window2);
  gtk_grab_add(window2);

}
