/*
#   kvpparse.c: the mixer and server command parsing mechanism used by IDJC.
#   Copyright (C) 2005-2007 Stephen Fairchild (s-fairchild@users.sourceforge.net)
#
#   This program is free software: you can redistribute it and/or modify
#   it under the terms of the GNU General Public License as published by
#   the Free Software Foundation, either version 3 of the License, or
#   (at your option) any later version.
#
#   This program is distributed in the hope that it will be useful,
#   but WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#   GNU General Public License for more details.
#
#   You should have received a copy of the GNU General Public License
#   along with this program in the file entitled COPYING.
#   If not, see <http://www.gnu.org/licenses/>.
*/

#define _GNU_SOURCE
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "kvpparse.h"

int kvp_parse(struct kvpdict *kvpdict, FILE *fp)
   {
   char *buffer = NULL, *key, *value;
   size_t n = 5000;
   ssize_t rv;

   buffer = malloc(5000);
   while (rv = getline(&buffer, &n, fp), rv > 0 && strcmp(buffer, "end\n"))
      {
      /* the following function is fed a key value pair e.g. key=value */
      value = kvp_extract_value((key = buffer)); /* key is truncated at the = */
      /* value = a pointer to a copy of the value part after the '=' allocated on the heap */
      if(!(kvp_apply_to_dict(kvpdict, key, value)))
         fprintf(stderr, "kvp_parse: %s=%s, key missing from dictionary\n", key, value);
      /* assuming the error message wasn't printed the associated pointer in the dictionary will have been updated */
      }

   if (buffer)
      free(buffer);
   else
      fprintf(stderr, "getline failed to allocate a buffer in function kvp_parse\n");
   return rv > 0;
   }
