#
#	$Id: commonfuncs.sh 1046 2007-07-15 08:47:27Z gromeck $
#
#	Copyright (c) 2004 by Christian Lorenz
#
#	common functions
#

################################################################################
#
#	print a message and exit
#
die()
{
	echo "$*"
	exit 1
}


################################################################################
#
#	run a niced command
#
nicerun()
{
	echo "$*" | tr "\n\t" "  " | tr --squeeze-repeats " " 
	echo
	nice $SHELL -c "$*"
	RC="$?"
	[ "$RC" != 0 ] && die "Command failed with exit code $RC"
}


################################################################################
#
#	set dimension 
#
#	input: MODE NORM FPS WIDTH HEIGHT BITRATE BITRATE_AUDIO SAMPLERATE VIDEOBUFFER
#	output: FORMAT FPS WIDTH HEIGHT BITRATE BITRATE_AUDIO SAMPLERATE VIDEOBUFFER
#
getvideoformat()
{
	MODE="$1"
	NORM="$2"
	case "$MODE" in
		vcd|VCD)
			#
			#	VCD output
			#
			WIDTH=352
			if [ "$NORM" = "p" ]; then
				HEIGHT=288
			else
				HEIGHT=288
			fi
			BITRATE_AUDIO=192
			BITRATE=$(( 1150 + $BITRATE_AUDIO ))
			FORMAT=2
			SAMPLERATE=44100
			VIDEOBUFFER=46
			;;
		svcd|SVCD)
			WIDTH=480
			if [ "$NORM" = "p" ]; then
				HEIGHT=576
			else
				HEIGHT=480
			fi
			BITRATE=2500
			BITRATE_AUDIO=192
			FORMAT=5
			SAMPLERATE=44100
			VIDEOBUFFER=230
			;;
		dvd|DVD)
			WIDTH=720
			if [ "$NORM" = "p" ]; then
				HEIGHT=576
			else
				HEIGHT=480
			fi
			BITRATE=7500
			BITRATE_AUDIO=192
			FORMAT=8
			SAMPLERATE=48000
			VIDEOBUFFER=300
			;;
		*)
			show_usage "Unknown mode '$MODE'"
	esac
	if [ "$NORM" = "p" ]; then
		FPS="25:1"
	else
		FPS="30000:1001"
	fi
	[ "$3" = "" ] && [ "$3" = "0" ] && FPS="$3"
	[ "$4" = "" ] && [ "$4" = "0" ] && WIDTH="$4"
	[ "$5" = "" ] && [ "$5" = "0" ] && HEIGHT="$5"
	[ "$6" = "" ] && [ "$6" = "0" ] && BITRATE="$6"
	[ "$7" = "" ] && [ "$7" = "0" ] && BITRATE_AUDIO="$6"
	[ "$8" = "" ] && [ "$8" = "0" ] && SAMPLERATE="$7"
	[ "$9" = "" ] && [ "$9" = "0" ] && VIDEOBUFFER="$8"
	echo "$FORMAT" "$FPS" "$WIDTH" "$HEIGHT" "$BITRATE" "$BITRATE_AUDIO" "$SAMPLERATE" "$VIDEOBUFFER"
}


#
#	return the width of the given image
#
image_width()
{
	echo $( identify -ping $1 | cut -f3 -d' ' | cut -f1 -d+ | cut -f1 -dx )
}

#
#	return the height of the given image
#
image_height()
{
	echo $( identify -ping $1 | cut -f3 -d' ' | cut -f1 -d+ | cut -f2 -dx )
}

#
#	probe TOOLAME to accept the sample frequence in kHz
#
probe_toolame_srate_hz()
{
	$1 -h 2>&1 | grep -i -c -- "-s.*rate in Hz"
}

#
#	probe ppmtoy4m to accept the mode 420mpeg2
#
probe_ppmtoy4m_420mpeg2()
{
	$1 -h 2>&1 | grep -i -c -- "420mpeg2"
}


#
#	EOF
#
