/*
**	$Id: aspectcorrection.h 937 2006-08-10 09:37:18Z gromeck $
**
**	Copyright (c) 2004 by Christian Lorenz
*/

#ifndef __GIP_ASPECTCORRECTION_H__
#define __GIP_ASPECTCORRECTION_H__ 1

#include <string.h>
#include "image.h"

/*
**	aspect correction modes
*/
#define GIP_ASPECTCORRECTION_TYPE_AUTO		0
#define GIP_ASPECTCORRECTION_TYPE_NONE		1
#define GIP_ASPECTCORRECTION_TYPE_FITIN		2
#define GIP_ASPECTCORRECTION_TYPE_FILLIN	3

/*
**	init & shutdown the API
*/
int GIP_aspectcorrection_init(void);
int GIP_aspectcorrection_exit(void);

/*
**	convert between the plain text type and the type code
*/
int GIP_aspectcorrection_str2type(const char *s);
const char *GIP_aspectcorrection_type2str(int type);
 
/*
**	do the aspect correction for the given image
*/
GIP_IMAGE_T *GIP_aspectcorrection_process(GIP_IMAGE_T *image,int width,int height,double aspectratio,int aspectcorrection);

#endif

/**/
