/*
**	$Id: audio.c 1062 2007-07-18 21:33:39Z gromeck $
**
**	Copyright (c) 2004 by Christian Lorenz
**
**	compute the time of a list of audio files
*/
#include <stdio.h>
#include <stdlib.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <unistd.h>
#include <string.h>
#include <sys/mman.h>
#include <locale.h>
#include <mad.h>
#include <config.h>
#include "gip.h"

#if !defined(O_BINARY)
#define O_BINARY  0
#endif

/*
**	init the API
*/
int GIP_audio_init(void)
{
	return 1;
}

/*
**	shutdown the API
*/
int GIP_audio_exit(void)
{
	return 1;
}

static signed int scan(unsigned char const *ptr, unsigned long len,
		mad_timer_t *duration)
{
  struct mad_stream stream;
  struct mad_header header;
  unsigned long bitrate, kbps, count;
  int vbr;

  mad_stream_init(&stream);
  mad_header_init(&header);

  mad_stream_buffer(&stream, ptr, len);

  bitrate = kbps = count = vbr = 0;

  while (1) {
    if (mad_header_decode(&header, &stream) == -1) {
      if (MAD_RECOVERABLE(stream.error))
	continue;
      else
	break;
    }

    if (bitrate && header.bitrate != bitrate)
      vbr = 1;

    bitrate = header.bitrate;

    kbps += bitrate / 1000;
    ++count;

    mad_timer_add(duration, header.duration);
  }

  mad_header_finish(&header);
  mad_stream_finish(&stream);

  if (count == 0)
    count = 1;

  return ((kbps * 2) / count + 1) / 2 * (vbr ? -1 : 1);
}

static
int calc(char const *path, mad_timer_t *duration,
	 signed int *kbps, unsigned long *kbytes)
{
  int fd;
  struct stat stat;
  void *fdm;

  fd = open(path, O_RDONLY | O_BINARY);
  if (fd == -1) {
    perror(path);
    return -1;
  }

  if (fstat(fd, &stat) == -1) {
    perror("fstat");
    close(fd);
    return -1;
  }

  if (!S_ISREG(stat.st_mode)) {
    fprintf(stderr,"%s: Not a regular file\n", path);
    close(fd);
    return -1;
  }

  *kbytes = (stat.st_size + 512) / 1024;

  fdm = mmap(0, stat.st_size, PROT_READ, MAP_SHARED, fd, 0);
  if (fdm == MAP_FAILED) {
    perror("mmap");
    close(fd);
    return -1;
  }

  if (fdm) {
    *kbps = scan(fdm, stat.st_size, duration);

    if (munmap(fdm, stat.st_size) == -1) {
      perror("munmap");
      close(fd);
      return -1;
    }
  }
  else
    *kbps = 0;

  if (close(fd) == -1) {
    perror("close");
    return -1;
  }

  return 0;
}

#if 0
static
void show(mad_timer_t duration, signed int kbps,
	  unsigned long kbytes, char const *label)
{
  char duration_str[19];

  mad_timer_string(duration, duration_str,
		   "%4lu:%02u:%02u.%1u", MAD_UNITS_HOURS,
		   MAD_UNITS_DECISECONDS, 0);

# if defined(HAVE_LOCALECONV)
  {
    char *point;

    point = strchr(duration_str, '.');
    if (point)
      *point = *localeconv()->decimal_point;
  }
# endif

  fprintf(stderr,"%8.1f MB  %c%3u kbps  %s  %s\n", kbytes / 1024.0,
	 kbps < 0 ? '~' : ' ', abs(kbps), duration_str, label);
}
#endif

double GIP_audio_duration(const char *audiofile)
{
	mad_timer_t duration = mad_timer_zero;
	signed int kbps;
    unsigned long kbytes;

    if (calc(audiofile, &duration, &kbps, &kbytes) == -1)
		return 0;

//    show(duration, kbps, kbytes, audiofile);

	return (double) duration.seconds + 1.0 / MAD_TIMER_RESOLUTION * duration.fraction;
}/**/
