/*
**	$Id: color.c 937 2006-08-10 09:37:18Z gromeck $
**
**	Copyright (c) 2004 by Christian Lorenz
**
**	color handling function
*/
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <string.h>
#include <config.h>
#include "gip.h"

/*
**	init the API
*/
int GIP_color_init(void)
{
	return 1;
}

/*
**	shutdown the API
*/
int GIP_color_exit(void)
{
	return 1;
}

/*
**	parse a color of the form [#]rrggbb
*/
void GIP_color_str2rgb(const char *rgb,int *r,int *g,int *b)
{
	unsigned long val;

#define GIP_COLOR_STR2RGB(str)	if (!strcasecmp(rgb,# str) || !strcasecmp(rgb,"GIP_COLOR_STR_" # str)) \
								rgb = GIP_COLOR_STR_ ## str;
	if (*rgb != '#') {
		rgb++;
		GIP_COLOR_STR2RGB(BLACK);
		GIP_COLOR_STR2RGB(RED);
		GIP_COLOR_STR2RGB(DARKRED);
		GIP_COLOR_STR2RGB(GREEN);
		GIP_COLOR_STR2RGB(DARKGREEN);
		GIP_COLOR_STR2RGB(BLUE);
		GIP_COLOR_STR2RGB(DARKBLUE);
		GIP_COLOR_STR2RGB(YELLOW);
		GIP_COLOR_STR2RGB(DARKYELLOW);
		GIP_COLOR_STR2RGB(CYAN);
		GIP_COLOR_STR2RGB(DARKCYAN);
		GIP_COLOR_STR2RGB(MAGENTA);
		GIP_COLOR_STR2RGB(DARKMAGENTA);
		GIP_COLOR_STR2RGB(WHITE);
		GIP_COLOR_STR2RGB(GREY0);
		GIP_COLOR_STR2RGB(GREY10);
		GIP_COLOR_STR2RGB(GREY20);
		GIP_COLOR_STR2RGB(GREY30);
		GIP_COLOR_STR2RGB(GREY40);
		GIP_COLOR_STR2RGB(GREY50);
		GIP_COLOR_STR2RGB(GREY60);
		GIP_COLOR_STR2RGB(GREY70);
		GIP_COLOR_STR2RGB(GREY80);
		GIP_COLOR_STR2RGB(GREY90);
		GIP_COLOR_STR2RGB(GREY100);
		GIP_COLOR_STR2RGB(GRAY0);
		GIP_COLOR_STR2RGB(GRAY10);
		GIP_COLOR_STR2RGB(GRAY20);
		GIP_COLOR_STR2RGB(GRAY30);
		GIP_COLOR_STR2RGB(GRAY40);
		GIP_COLOR_STR2RGB(GRAY50);
		GIP_COLOR_STR2RGB(GRAY60);
		GIP_COLOR_STR2RGB(GRAY70);
		GIP_COLOR_STR2RGB(GRAY80);
		GIP_COLOR_STR2RGB(GRAY90);
		GIP_COLOR_STR2RGB(GRAY100);
	}
	val = strtol((*rgb == '#') ? rgb + 1 : rgb,NULL,16);
	*r = (val & 0xff0000) >> 16;
	*g = (val & 0x00ff00) >>  8;
	*b = (val & 0x0000ff) >>  0;
	DEBUG("%s=(%d,%d,%d)\n",rgb,*r,*g,*b);
#undef GIP_COLOR_STR2RGB
}

/*
**	convert RGB into a string
*/
const char *GIP_color_rgb2str(int r,int g,int b,char *rgbstr)
{
	sprintf(rgbstr,"#%02x%02x%02x",r,g,b);
	return rgbstr;
}/**/
