/*
**	$Id: error.c 1071 2007-07-19 10:05:43Z gromeck $
**
**	Copyright (c) 2004 by Christian Lorenz
*/
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <stdarg.h>
#include <string.h>
#include <ctype.h>
#include <errno.h>
#include <config.h>
#include "gip.h"

static FILE *_logfd = NULL;

/*
**	init the error functions
*/
int GIP_error_init(void)
{
	DEBUG("opening %s\n",_gip_setup.logfile);
	if (!_gip_setup.logfile)
		_logfd = NULL;
	else if (!strcmp(_gip_setup.logfile,"-"))
		_logfd = stderr;
	else {
		if (!(_logfd = fopen(_gip_setup.logfile,"w+")))
			CRITICAL("fopen(%s) failed\n",_gip_setup.logfile);
	}
	return 1;
}

/*
**	shutdown the API
*/
int GIP_error_exit(void)
{
	if (_logfd) {
		if (_logfd != stderr)
			fclose(_logfd);
		_logfd = NULL;
	}
	return 1;
}

static void print_msg(FILE *fd,const char *file,const char *func,int line,const char *buffer)
{
	if (fd) {
		fprintf(fd,"%s[%lu]:%s:%s:%d: %s",
				_gip_setup.title,(unsigned long) getpid(),
				file,func,line,buffer);
		fflush(fd);
	}
}

/*
**	print messages
*/
void GIP_error_log(const char *file,const char *func,int line,const char *fmt,...)
{
	va_list va;
	char buffer[1000];

    /*
    **  format the output
    */
	va_start(va,fmt);

#if defined (__GNU_LIBRARY__) && __GLIBC__ >= 2 && __GLIBC_MINOR__ < 1
	if (vsnprintf(buffer,sizeof(buffer),fmt,va) < 0) {
#else
	if (vsnprintf(buffer,sizeof(buffer),fmt,va) > sizeof(buffer)) {
#endif
		buffer[sizeof(buffer)-1]='\0'; /* force string termination */
	}
	va_end(va);

	print_msg(_logfd,file,func,line,buffer);
}

/*
**	exit handler to report Devil errors
*/
void GIP_error_print(int terminate,const char *file,const char *func,int line,const char *fmt,...)
{
	va_list va;
	char buffer[1000];

    /*
    **  format the output
    */
	va_start(va,fmt);

#if defined (__GNU_LIBRARY__) && __GLIBC__ >= 2 && __GLIBC_MINOR__ < 1
	if (vsnprintf(buffer,sizeof(buffer),fmt,va) < 0) {
#else
	if (vsnprintf(buffer,sizeof(buffer),fmt,va) > sizeof(buffer)) {
#endif
		buffer[sizeof(buffer)-1]='\0'; /* force string termination */
	}
	va_end(va);

	print_msg(stderr,file,func,line,buffer);
	if (_logfd != stderr)
		print_msg(_logfd,file,func,line,buffer);

	if (terminate)
		exit(terminate);
}/**/
