/*
**	$Id: error.h 1071 2007-07-19 10:05:43Z gromeck $
**
**	Copyright (c) 2004 by Christian Lorenz
*/

#ifndef __GIP_ERROR_H__
#define __GIP_ERROR_H__ 1

/*
**  use the GNU feature macro __(PRETTY_)FUNCTION__ if possible
*/
#ifdef __GNUC__
#define __FUNC__                        (__FUNCTION__)
#else
#define __FUNC__                        ("")
#endif

/*
**	macros for error handling
*/
#define LOG(format...)			GIP_error_log(__FILE__,__FUNC__,__LINE__,format)
#define INFORMATION(format...)	GIP_error_print(0,__FILE__,__FUNC__,__LINE__,format)
#define WARNING(format...)		GIP_error_print(0,__FILE__,__FUNC__,__LINE__,format)
#define CRITICAL(format...)		GIP_error_print(1,__FILE__,__FUNC__,__LINE__,format)
#ifdef DEBUGGING
#define DEBUG(format...)		GIP_error_print(0,__FILE__,__FUNC__,__LINE__,format)
#else
#define DEBUG(format...)		{}
#endif

/*
**	init & shutdown the API
*/
int GIP_error_init(void);
int GIP_error_exit(void);

/*
**	error handling functions
*/
void GIP_error_log(const char *file,const char *func,int line,const char *fmt,...);

void GIP_error_print(int terminate,const char *file,const char *func,int line,const char *fmt,...)
			__attribute__ ((format(printf,5,6)));

#endif

/**/
