/*
**	$Id: geometry.h 1084 2007-07-31 08:45:58Z gromeck $
**
**	Copyright (c) 2004 by Christian Lorenz
**
**	handle geometries
*/

#ifndef __GIP_GEOMETRY_H__
#define __GIP_GEOMETRY_H__ 1

#define GIP_GEOMETRY_PERCENT_100		"100%"
#define GIP_GEOMETRY_PERCENT_90			"90%"
#define GIP_GEOMETRY_PERCENT_80			"80%"
#define GIP_GEOMETRY_PERCENT_70			"70%"
#define GIP_GEOMETRY_PERCENT_60			"60%"
#define GIP_GEOMETRY_PERCENT_50			"50%"
#define GIP_GEOMETRY_PERCENT_40			"40%"
#define GIP_GEOMETRY_PERCENT_30			"30%"
#define GIP_GEOMETRY_PERCENT_20			"20%"
#define GIP_GEOMETRY_PERCENT_10			"10%"

#define GIP_GEOMETRY_PERCENT_KENBURNS	GIP_GEOMETRY_PERCENT_80

/*
**	init & shutdown the API
*/
int GIP_geometry_init(void);
int GIP_geometry_exit(void);

/*
**	parse a geometry string and return the dimensions
*/
int GIP_geometry_parse(const char *geo,
		int image_width,int image_height,
		int frame_width,int frame_height,
		int *x,int *y,int *w,int *h);

/*
**	process the geometry
*/
int GIP_geometry_process(const char *from_geo,const char *to_geo,
		int image_width,int image_height,
		int frame_width,int frame_height,
		int step,int steps,
		int *x,int *y,int *w,int *h);

#endif

/**/
