/*
**	$Id: gip.c 1076 2007-07-19 10:37:57Z gromeck $
**
**	Copyright (c) 2004 by Christian Lorenz
**
**	GIP API
*/
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <time.h>
#include <string.h>
#include <config.h>
#include "gip.h"

/*
**	the setup struct
*/
GIP_SETUP_T _gip_setup;

/*
**	init the API
*/
int GIP_init(const char *title,const char *logfile,int quick_mode,const char *resize_filter,int prescale_factor,int maxupscale_factor)
{
	int rc = 1;

	/*
	**	setup the setup struct
	*/
	memset(&_gip_setup,0,sizeof(_gip_setup));
	_gip_setup.quick_mode = quick_mode;
	_gip_setup.resize_filter = (resize_filter) ? strdup(resize_filter) : NULL;
	_gip_setup.title = (title) ? strdup(title) : NULL;
	_gip_setup.logfile = (logfile) ? strdup(logfile) : NULL;
	_gip_setup.prescale_factor = (prescale_factor > 0) ? prescale_factor : 0;
	_gip_setup.maxupscale_factor = (maxupscale_factor > 0) ? maxupscale_factor : 0;

	/*
	**	init the other components
	*/
	rc = rc && GIP_error_init();
	rc = rc && GIP_progress_init();
	rc = rc && GIP_color_init();
	rc = rc && GIP_geometry_init();
	rc = rc && GIP_times_init();
	rc = rc && GIP_transition_init();
	rc = rc && GIP_image_init();
	rc = rc && GIP_aspectcorrection_init();
	rc = rc && GIP_audio_init();
	rc = rc && GIP_index_init();
	return rc;
}

/*
**	shutdown the API
*/
int GIP_exit(void)
{
	int rc = 1;

	/*
	**	shutdown the other components
	*/
	rc = rc && GIP_index_exit();
	rc = rc && GIP_audio_exit();
	rc = rc && GIP_aspectcorrection_exit();
	rc = rc && GIP_image_exit();
	rc = rc && GIP_transition_exit();
	rc = rc && GIP_times_exit();
	rc = rc && GIP_geometry_exit();
	rc = rc && GIP_color_exit();
	rc = rc && GIP_progress_exit();
	rc = rc && GIP_error_exit();

	/*
	**	de-alloc some stuff of the setup
	*/
	if (_gip_setup.resize_filter)
		free(_gip_setup.resize_filter);
	if (_gip_setup.title)
		free(_gip_setup.title);
	if (_gip_setup.logfile)
		free(_gip_setup.logfile);
	memset(&_gip_setup,0,sizeof(_gip_setup));

	return rc;
}

/*
**	return the low-level library
*/
const char *GIP_version(char *version)
{
#if HAVE_LIBMAGICK
	unsigned long version_number;
#endif

#if HAVE_LIBMAGICK
	sprintf(version,"GIP V" __VERSION_NR__ "; %s",GetMagickVersion(&version_number));
#endif
#if HAVE_LIBIL
	sprintf(version,"GIP V" __VERSION_NR__ "; Developer's Image Library (DevIL) V%d",IL_VERSION);
#endif
	return version;
}/**/
