/*
**	$Id: gip.h 1076 2007-07-19 10:37:57Z gromeck $
**
**	Copyright (c) 2004 by Christian Lorenz
**
**	GIP API header
*/

#ifndef __GIP_H__
#define __GIP_H__ 1

#if HAVE_LIBMAGICK
#include <magick/api.h>
#include <magick/ImageMagick.h>
#endif
#if HAVE_LIBIL
#include <IL/il.h>
#include <IL/ilu.h>
#endif

#include "../../config.h"
#include "audio.h"
#include "color.h"
#include "error.h"
#include "geometry.h"
#include "times.h"
#include "image.h"
#include "index.h"
#include "progress.h"
#include "transition.h"
#include "aspectcorrection.h"

/*
**	this is a structure which holds all
**	setup/configuration information
**
**	it is passed to all the GIP modules
*/
typedef struct {
	int quick_mode;			// generate the result quick (poor quality)
	char *title;			// application title
	char *logfile;			// name of the logfile
	char *resize_filter;	// name of the resize filter to use (if NULL, we will use the standard filters)
	int prescale_factor;	// the prescale factor; if 0, use default
	int maxupscale_factor;	// the max upscale factor; if 0, use default
} GIP_SETUP_T;

/*
**	the setup struct
*/
extern GIP_SETUP_T _gip_setup;

/*
**	init and exit all the APIs
*/
int GIP_init(const char *title,const char *logfile,int quick_mode,const char *resize_filter,int prescale_factor,int maxupscale_factor);
int GIP_exit(void);

/*
**	return a version string
*/
const char *GIP_version(char *version);

#endif

/**/
