/*
**	$Id: image.h 1071 2007-07-19 10:05:43Z gromeck $
**
**	Copyright (c) 2004 by Christian Lorenz
**
**	handle images
*/

#ifndef __GIP_IMAGE_H__
#define __GIP_IMAGE_H__ 1

#if HAVE_LIBMAGICK
#include <magick/api.h>
#include <magick/ImageMagick.h>
#endif
#if HAVE_LIBIL
#include <IL/il.h>
#include <IL/ilu.h>
#endif

typedef struct _GIP_image {
	int width;
	int height;
#if HAVE_LIBMAGICK
	Image *image;
#endif
#if HAVE_LIBIL
	unsigned int id;
#endif
} GIP_IMAGE_T;

/*
**	init & shutdown the API
*/
int GIP_image_init(void);
int GIP_image_exit(void);

/*
**	image IO functions
*/
GIP_IMAGE_T *GIP_image_load(const char *file);
GIP_IMAGE_T *GIP_image_loadfd(FILE *stream);
int GIP_image_save(const GIP_IMAGE_T *img,const char *file);
int GIP_image_savefd(const GIP_IMAGE_T *img,FILE *stream);

/*
**	image creation & destruction functions
*/
GIP_IMAGE_T *GIP_image_create(const char *rgbcolor,int width,int height);
GIP_IMAGE_T *GIP_image_duplicate(const GIP_IMAGE_T *src);
int GIP_image_free(GIP_IMAGE_T *img);

/*
**	image operations
*/
int GIP_image_blend(GIP_IMAGE_T *dst,const GIP_IMAGE_T *src0,const GIP_IMAGE_T *src1,float a);
int GIP_image_overlay(GIP_IMAGE_T *dst,int dx,int dy,const GIP_IMAGE_T *src);
int GIP_image_bitblit(GIP_IMAGE_T *dst,int dx,int dy,const GIP_IMAGE_T *src,int sx,int sy,int w,int h);
int GIP_image_scale(GIP_IMAGE_T *img,int width,int height);
int GIP_image_scaleblit(GIP_IMAGE_T *dimg,int dx,int dy,int dw,int dh,const GIP_IMAGE_T *simg,int sx,int sy,int sw,int sh);
GIP_IMAGE_T *GIP_image_geoscale(const GIP_IMAGE_T *img,int x,int y,int w,int h,int width,int height);
GIP_IMAGE_T *GIP_image_border(const GIP_IMAGE_T *img,const char *rgbcolor,int bw,int bh);

#endif

/**/
