/*
**	$Id: progress.h 937 2006-08-10 09:37:18Z gromeck $
**
**	Copyright (c) 2004 by Christian Lorenz
**
**	handle geometries
*/

#ifndef __GIP_PERCENTAGE_H__
#define __GIP_PERCENTAGE_H__ 1

typedef struct _gip_progress {
	int max;			// the predicted maximum value
	float percent;		// actual percentage
	time_t start;		// start time of processing
	FILE *stream;		// output stream of the progress display
	char *units;		// the units (eg. frames, ...)

	/*
	**	runtime variables
	*/
	time_t last;		// time of the last update
	int last_n;			// last update value
	int eta;			// estimated time of arrival
	double ups;			// current units per second
	int tick;			// current tick -- used for the rotor
} GIP_PROGRESS_T;

/*
**	init & shutdown the API
*/
int GIP_progress_init(void);
int GIP_progress_exit(void);

/*
**	start, update & complete the progress meter
*/
GIP_PROGRESS_T *GIP_progress_start(int max,const char *units,FILE *stream);
void GIP_progress_update(GIP_PROGRESS_T *progress,int n);
void GIP_progress_complete(GIP_PROGRESS_T *progress);

#endif

/**/
