/*
**	$Id: times.c,v 1.1 2007/02/12 14:57:00 xanni Exp $
**
**	Copyright (c) 2007 by Andrew Pam
**
**	handle times
**
**	$Log: times.c,v $
**	Revision 1.1  2007/02/12 14:57:00  xanni
**	INITIAL CHECK-IN
**	
*/
#include <stdio.h>
#include <stdlib.h>
#include "gip.h"

/*
**	init the API
*/
int GIP_times_init(void)
{
	return 1;
}

/*
**	shutdown the API
*/
int GIP_times_exit(void)
{
	return 1;
}

/*
**	parse a time string and return the number of frames
**
**	time strings are of the form
**
**		{<hours>:}{<minutes>:}<seconds>
**		where <seconds> can optionally be a decimal fraction
*/
int GIP_time2frames(const char *time, double framerate)
{
	int f = 0;
	long ms;
	char *s;

	DEBUG("time:%s	framerate:%f\n", time, framerate);

	/*
	**	no time => use the default
	*/
	if (!time)
		time = "1";

	/*
	**	handle negative times
	*/
	if (time[0] == '-')
		return -1;

	/*
	**	find and parse time
	*/
	ms = abs(atoi(time));

	/* hours and minutes, if any */
	if ((s = strchr(time, ':'))) {
		ms *= 60 + abs(atoi(++s));
		if ((s = strchr(s, ':')))
			ms *= 60 + abs(atoi(++s));
	}

	ms *= 1000;
	/* fractional seconds, if any */
	if ((s = strchr(time, '.')))
	{
		ms += (*++s - '0') * 100;
		if (*++s)
		{
			ms += (*s - '0') * 10;
			if (*++s)
				ms += *s - '0';
		}
	}

	/* calculate number of frames with rounding */
	f = (int) (((ms * framerate) + 500) / 1000);

	DEBUG("time:%s	framerate:%f	ms:%ld	frames:%d\n", time, framerate, ms, f);
	return f;
}

/*
**	convert a number of frames to a time string
*/
const char *GIP_frames2time(int frames, double framerate, char *time)
{
	if (frames < 0)
		strcpy(time, "-1");
	else
	{
		double ms = (frames * 1000) / framerate;
		int h = (int) (ms / (1000 * 60 * 60));
		int m = (int) (ms / (1000 * 60)) % 60;
		int s = (int) (ms / 1000) % 60;
		int f = (int) ((long) ms % 1000);
		time[0] = '\0';
		char t[15];
		DEBUG("frames:%d	framerate:%f	ms:%f	hmsf:%02d:%02d:%02d.%03d\n", frames, framerate, ms, h, m, s, f);

		if (h) {
			sprintf(t, "%d:", h);
			strcat(time, t);
		}
		if (m) {
			sprintf(t, (time[0] ? "%02d:" : "%d:"), m);
			strcat(time, t);
		}
		sprintf(t, (time[0] ? "%02d" : "%d"), s);
		strcat(time, t);
		if (f) {
			sprintf(t, ".%03d", f);
			strcat(time, t);
		}

		DEBUG("frames:%d	framerate:%f	ms:%f	time:%s\n", frames, framerate, ms, time);
	}
	return time;
}/**/
