/*
**	$Id: transition.h 937 2006-08-10 09:37:18Z gromeck $
**
**	Copyright (c) 2004 by Christian Lorenz
*/

#ifndef __GIP_TRANSITION_H__
#define __GIP_TRANSITION_H__ 1

#include <string.h>
#include "image.h"

/*
**	transition modes
*/
#define GIP_TRANSITION_TYPE_RANDOM		-1

/*
**	FADE transitions use some pseudo transitions to
**	give this transition the same chance as the others
*/
#define GIP_TRANSITION_TYPE_FADE		0
#define GIP_TRANSITION_TYPE_FADE_1		1
#define GIP_TRANSITION_TYPE_FADE_2		2
#define GIP_TRANSITION_TYPE_FADE_3		3

#define GIP_TRANSITION_TYPE_SLIDE_L2R	4	// slide left to right
#define GIP_TRANSITION_TYPE_SLIDE_R2L	5	// slide right to left
#define GIP_TRANSITION_TYPE_SLIDE_T2B	6	// slide top to bottom
#define GIP_TRANSITION_TYPE_SLIDE_B2T	7	// slide bottom to top

#define GIP_TRANSITION_TYPE_PUSH_L2R	8	// push left to right
#define GIP_TRANSITION_TYPE_PUSH_R2L	9	// push right to left
#define GIP_TRANSITION_TYPE_PUSH_T2B	10	// push top to bottom
#define GIP_TRANSITION_TYPE_PUSH_B2T	11	// push bottom to top

#define GIP_TRANSITION_TYPE_SWAP_L2R	12	// swap left to right
#define GIP_TRANSITION_TYPE_SWAP_R2L	13	// swap right to left
#define GIP_TRANSITION_TYPE_SWAP_T2B	14	// swap top to bottom
#define GIP_TRANSITION_TYPE_SWAP_B2T	15	// swap bottom to top

#define GIP_TRANSITION_TYPE_ROLL_L2R	16	// roll left to right
#define GIP_TRANSITION_TYPE_ROLL_R2L	17	// roll right to left
#define GIP_TRANSITION_TYPE_ROLL_T2B	18	// roll top to bottom
#define GIP_TRANSITION_TYPE_ROLL_B2T	19	// roll bottom to top

/*
**
**	disabled the split tranistion, because sometimes it doesn't
**	look good if people got beheaded
*/
#if 0
#define GIP_TRANSITION_TYPE_SPLIT_HIN	20	// split horizontal/in
#define GIP_TRANSITION_TYPE_SPLIT_VIN	21	// split vertical/in
#define GIP_TRANSITION_TYPE_SPLIT_HOUT	22	// split horizontal/out
#define GIP_TRANSITION_TYPE_SPLIT_VOUT	23	// split vertical/out

#define GIP_TRANSITION_TYPE_MAX			23	// set this to the highest transition value
#else
#define GIP_TRANSITION_TYPE_MAX			19	// set this to the highest transition value
#endif


/*
**	init & shutdown the API
*/
int GIP_transition_init(void);
int GIP_transition_exit(void);

/*
**	convert between the plain text type and the type code
*/
int GIP_transition_str2type(const char *s);
const char *GIP_transition_type2str(int type);

/*
**	return a random transition
*/
int GIP_transition_random(void);

/*
**	do a transition from src0 -> src1 and uses dst as a buffer
*/
GIP_IMAGE_T *GIP_transition_process(const GIP_IMAGE_T *from,const GIP_IMAGE_T *to,int type,int step,int steps);

#endif

/**/
