/*
    Copyright ( C ) 2004 Arnold Krille <arnold@arnoldarts.de>

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation;
    version 2 of the License.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
    Boston, MA 02111-1307, USA.

*/

#ifndef JACKMIX_VOLUMEGROUP_AUX_PRIVATE_H
#define JACKMIX_VOLUMEGROUP_AUX_PRIVATE_H

#include "volumegroup.h"

namespace JackMix {

class VGAuxMasterWidget : public VolumeGroupMasterWidget {
Q_OBJECT
public:
	VGAuxMasterWidget( VGAux*, QWidget* =0, const char* =0 );
	~VGAuxMasterWidget();
private slots:
	void newValue( QString, float );
};

class VGAuxChannelWidget : public VolumeGroupChannelWidget {
Q_OBJECT
public:
	VGAuxChannelWidget( QString, VGAux*, QWidget*, const char* =0 );
	~VGAuxChannelWidget();
private slots:
	void valueChanged( QString, float );
};

};

#endif

