//
// C++ Interface: fileselector
//
// Description: 
//
//
// Author: Andreas Silberstorff <andreas@andreas-silberstorff.de>, (C) 2005
//
// Copyright: See COPYING file that comes with this distribution
//
// based on the fileselector widget from kdevelop
// (c) 2001 by Bernd Gehrmann                                  *
//   bernd@kdevelop.org
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License as
// published by the Free Software Foundation; either version 2 of
// the License, or (at your option) any later version
//******************************************************************

#ifndef _FILESELECTOR_H_
#define _FILESELECTOR_H_

#include <qlayout.h>
#include <qpushbutton.h>
#include <qhbox.h>
#include <qlabel.h>
#include <qstrlist.h>
#include <qtooltip.h>

#include <klistview.h>
#include <qvbox.h>
#include <qwidget.h>
#include <kfile.h>
#include <kurlcombobox.h>
#include <kurlcompletion.h>
#include <kcombobox.h>
#include <kprotocolinfo.h>

#include <kfileview.h>
#include <kfileitem.h>

#include <kdiroperator.h>

class KFile;
class KProcess;

class KDnDDirOperator : public KDirOperator
{
	Q_OBJECT

public:
	KDnDDirOperator ( const KURL&    urlName = KURL(),
	                        QWidget *parent  = 0,
	                  const char*    name    = 0 );

public slots:
        virtual void myhome();
        virtual void slotPlay();
        virtual void slotEdit();

private:
        KProcess* m_proc;
        virtual QString playCmd();
        virtual QString editCmd();

private slots:
        virtual void    slotMplayerExited(KProcess *);

protected:
        virtual KFileView* createView( QWidget*        parent,
	                                 KFile::FileView view );
};

class FileSelectorWidget : public QWidget
{
	Q_OBJECT

public:
	FileSelectorWidget(       KFile::Mode,
	                          QWidget*     parent = 0,
	                    const char*        name   = 0 );
	~FileSelectorWidget();

	KDnDDirOperator * dirOperator()
	{
		return dir;
	}

public slots:
	void slotFilterChanged( const QString& );
	void setDir( KURL );
	void setDir( const QString& );

private slots:
	void cmbPathActivated( const KURL& u );
	void cmbPathReturnPressed( const QString& u );
	void dirUrlEntered( const KURL& u );
	void dirFinishedLoading();
	void filterReturnPressed( const QString& nf );

protected:
	void focusInEvent( QFocusEvent* );
	void dragEnterEvent ( QDragEnterEvent* ev );
	void dropEvent ( QDropEvent* ev );

private:
	KURLComboBox      *cmbPath;
	KHistoryCombo     *filter;
	QLabel            *filterIcon;
	KDnDDirOperator   *dir;
	QPushButton       *home, *up, *back, *forward;
	QPushButton       *myhome;
	QPushButton       *play, *edit;

signals:
	void dropped ( const QString& );
};

#endif 

