/***************************************************************************
 *   Copyright (C) 2005-2006 by Andreas Silberstorff   *
 *   ml@andreas-silberstorff.de   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Steet, Fifth Floor, Boston, MA 02110-1301, USA.             *
 *                                                                         *
 *   In addition, as a special exception, the copyright holders give       *
 *   permission to link the code of this program with any edition of       *
 *   the Qt library by Trolltech AS, Norway (or with modified versions     *
 *   of Qt that use the same license as Qt), and distribute linked         *
 *   combinations including the two.  You must obey the GNU General        *
 *   Public License in all respects for all of the code used other than    *
 *   Qt.  If you modify this file, you may extend this exception to        *
 *   your version of the file, but you are not obligated to do so.  If     *
 *   you do not wish to do so, delete this exception statement from        *
 *   your version.                                                         *
 ***************************************************************************/


#ifndef _KALVA_H_
#define _KALVA_H_

//???????????
// #ifdef HAVE_CONFIG_H
// #include <config.h>
// #endif

#include <kapplication.h>
#include <kmainwindow.h>
#include <kparts/componentfactory.h>
#include "kalvaview.h"
#include <kchlstfilterplugin.h>
#include "mychannellistinterface.h"

//class QPrinter;
class KToggleAction;
class KURL;
class SystemTray;
class KalvaView;
class KalvaProfileChooserCombo;
class KProcess;

/**
 * This class serves as the main window for Kalva.  It handles the
 * menus, toolbars, and status bars.
 *
 * @short Main window class
 * @author Andreas Silberstorff <ml@andreas-silberstorff.de>
 * @version 0.1
 */

class Kalva : public KMainWindow
{
    Q_OBJECT
public:
	Kalva();
	~Kalva();

public slots:
	virtual void tipOfTheDay();
	// Shouldn't be defined here...
	void slotSetChlst( const QString & profile );

protected:
	void loadPlugins();
	void reloadPlugins();


private slots:
	void optionsPreferences();
	void slotTipOfTheDay();
	void slotToggleSystemTray(bool enabled);

	void changeStatusbar(const QString& text);
	void changeCaption(const QString& text);
	void slotConfigureKeys();
	void slotConfigureToolbars();
	void saveNewToolbarConfig(); 
	void slotAboutToQuit();
	void slotQuit();
	void readConfig();
	void saveConfig(); 
	void slotSettingsChanged();

	void slotStartEPG();

	virtual bool queryExit();
	virtual bool queryClose();

private:
	void setupAccel();
	void setupProfileChoosers();
	void setupActions();
	void setupPlugins();
	void setupSystemTray();
	void debugPluginInstanciationErrNo ( const int & ErrNo );

private:
    bool m_startDocked;
    bool m_shuttingDown;

    KalvaView     *m_view;
    SystemTray    *m_systemTray;
    QPrinter      *m_printer;
    KToggleAction *m_toolbarAction;
    KToggleAction *m_statusbarAction;
    KToggleAction *m_toggleSystemTrayAction;
    KToggleAction *m_toggleDockOnCloseAction;
    QObject       *m_pluginInterface;
    KProcess      *m_proc;
	KalvaProfileChooserCombo* hwprofilechooser;
	KalvaProfileChooserCombo* qprofilechooser;
	KalvaProfileChooserCombo* chlstchooser;
};

#endif // _KALVA_H_

