//
// C++ Interface: kalvacmd
//
// Description: 
//
//
// Author: Andreas Silberstorff <andreas@andreas-silberstorff.de>, (C) 2005-2006
//
// Copyright: See COPYING file that comes with this distribution
//
//
#ifndef KALVACMD_H
#define KALVACMD_H

#include <qstring.h>
#include <qdatetime.h>

class KalvaProfile;

class QWidget;

class KalvaCropAndAspect  
{
public:
	KalvaCropAndAspect( const float overscan,
			    const QString res,
			    const QString targetedAspect )
	: m_overscan(overscan), m_res(res), m_targetedAspect(targetedAspect)
	{}
	~KalvaCropAndAspect();

	double getAspect()  { return m_aspect; };
	QString getCrop()  { return m_crop; };
	void compute();

protected:
	double m_aspect;
	QString m_crop;
	float m_overscan;
	QString m_res;
	QString m_targetedAspect;
};

/**
Build Player- and Recordercommand

@author Andreas Silberstorff
*/
class KalvaCmd : public QString
{
//Q_OBJECT

public:
	KalvaCmd( QWidget * p );
	~KalvaCmd() {}

	virtual bool read();

	virtual void playMovieCmd(const QString & movieFiles);

	virtual void playCmd(     const QString & station,
                                  const QString & channel,
                                  const QString & freq
                                  );
	virtual void playCmdAnalog(
				  const QString & channel,
                                  const QString & freq
                                  );
	virtual void playCmdIVTV(  const QString & channel
                                  );
	virtual void playCmdDVB(  const QString & station
                                  );
	virtual void recordCmd(
                                  const QString & filmtitle,
                                  const QString & station,
                                  const QString & duration,
                                  const QString & channel,
                                  const QString & freq
                                  );
	virtual void recordCmdAnalogue(
                                  const QString & filmtitle,
                                  const QString & station,
                                  const QString & duration,
                                  const QString & channel,
                                  const QString & freq
                                  );
	virtual void recordCmdIVTV(
                                  const QString & filmtitle,
                                  const QString & station,
                                  const QString & channel,
                                  const QString & duration
                                  );
	virtual void recordCmdDVB(
                                  const QString & filmtitle,
                                  const QString & station,
                                  const QString & duration
                                  );
	virtual void recordCmdDVBAsDivX4(
                                  const QString & filmtitle,
                                  const QString & station,
                                  const QString & duration
                                  );

	QString getAumixdev ( const QString& audiodev );
	QString getCrop()  { return crop; }
	double getAspect() { return aspect; }
	void computeCropAndAspect();
	
private:
    virtual void setTitle(        const QString & filmtitle,
                                  const QString & station
                              );
    virtual QString getTuner();
    virtual QString getTvScale();
    virtual void prepareAumix();
    virtual void setAumixPrePlay();
    virtual void setAumixPostPlay();
    virtual void setAumixPreRec();
    virtual void setAumixPostRec();
    virtual void setNice();
    virtual void setURLtv();
    virtual void setURLdvb();
    virtual void setInputOptsTV( QString & Opts);
    virtual void setInputOptsPost( QString & Opts);
    virtual void setLavcOpts( QString & Opts );
    virtual void setEncoderOptsPost( QString & Opts);
    virtual void setFilterRect( QString & filter );
    virtual void setFilterCrop( QString & filter );
    virtual void setFilterPre( QString & filter );
    virtual void setFilterPP( QString & filter );
    virtual void setFilterScale( QString & filter );
    virtual void setFilterAspect( QString & filter );
    virtual void setFilterDenoiser( QString & filter );
    virtual void setFilterPost( QString & filter );
    virtual void setBitrate( QString & lavcOpts );
    virtual double Bitrate();
    virtual void setVerbosity();

    QWidget * m_parent;
    KalvaProfile* m_hwprofile;
    KalvaProfile* m_qprofile;

    QString crop;
    double aspect;

    QString aumix;
    QString aumixdev;
    QString m_station;
    QString m_freq;
    QString m_channel;
    QString driver;
    QString norm;
    QString tv_scale;
    QString x_scale;
    QString y_scale;
    QString start;
    QString dow;
    QTime m_duration;
};

#endif
