//
// C++ Interface: kalvaprofile
//
// Description: 
//
//
// Author: Andreas Silberstorff <ml@andreas-silberstorff.de>, (C) 2006
//
// Copyright: See COPYING file that comes with this distribution
//
//
#ifndef KALVAPROFILEKALVAPROFILE_H
#define KALVAPROFILEKALVAPROFILE_H
#include <qmap.h>

class QString;
class QStringList;

class Value
{
public:
	Value() {}
        Value( const QString& cat, const QString& val )
            : category(cat), value(val)
        { }

        QString getCategory() const { return category; }
        QString getValue() const { return value; }
        void setCategory( const QString cat ) { category = cat; }
        void setValue( const QString val )  { value = val; }

        QString category;
        QString value;
};

/**
represents a profile. provides getters and setters for profile data fields and read and write methods

@author Andreas Silberstorff
*/
class KalvaProfile
{
public:
//    KalvaProfile();
	KalvaProfile( int type );

	~KalvaProfile();

	QString getDir();
	QString getFilename();
	QString getFilename( QString basename );

	QStringList readDir();
	bool read( const QString filename );
	bool write( const QString filename );

	QString getCategory( const QString key );
        Value getValue( const QString key );
	QString getValueString( const QString key );
	int getValueInt( const QString key );
	double getValueDouble( const QString key );
	float getValueFloat( const QString key );
	bool getValueBoolean( const QString key );
	void setValue( const QString key, const QString cat, const QString val );

private:
	QString m_filename;
	QString m_type;
	typedef QMap<QString, Value> profileDataMap;
	profileDataMap m_profileData;
};

static const int KALVA_CHANNELLIST = 0;
static const int KALVA_HARDWARE_PROFILE = 1;
static const int KALVA_QUALITY_PROFILE = 2;

static const QString CHANNELLIST = "chlst";
static const QString HARDWARE_PROFILE = "hwprofile";
static const QString QUALITY_PROFILE = "qprofile";


#endif
