/***************************************************************************
 *   Copyright (C) 2005-2006 by Andreas Silberstorff   *
 *   ml@andreas-silberstorff.de   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Steet, Fifth Floor, Boston, MA 02110-1301, USA.             *
 *                                                                         *
 *   In addition, as a special exception, the copyright holders give       *
 *   permission to link the code of this program with any edition of       *
 *   the Qt library by Trolltech AS, Norway (or with modified versions     *
 *   of Qt that use the same license as Qt), and distribute linked         *
 *   combinations including the two.  You must obey the GNU General        *
 *   Public License in all respects for all of the code used other than    *
 *   Qt.  If you modify this file, you may extend this exception to        *
 *   your version of the file, but you are not obligated to do so.  If     *
 *   you do not wish to do so, delete this exception statement from        *
 *   your version.                                                         *
 ***************************************************************************/


#include "kalva.h"
#include <kuniqueapplication.h>
#include <kaboutdata.h>
#include <kcmdlineargs.h>
#include <klocale.h>
#include <kconfigbase.h>
#include <kconfig.h>
#include <dcopclient.h>

static const char description[] =
    I18N_NOOP("Kalva is A Lightweight Videorecorder Application\n\nKalva uses MEncoder for tv recording and schedules Your movie or serial recording via at and cron.\nIf You exchange the K in Kalva with C(++) it tastes good and allways makes appetite for more.\n\nEnjoy and have lots of fun.");

static const char version[] = "0.8.90";

static KCmdLineOptions options[] =
{
    { "+[URL]", I18N_NOOP( "Document to open" ), 0 },
    KCmdLineLastOption
};

int main(int argc, char **argv)
{
    KAboutData about("kalva",
                     I18N_NOOP("Kalva"),
                     version,
                     description,
                     KAboutData::License_GPL_V2,
                     "(C) 2005-2008 Andreas Silberstorff",
                     0,
                     0,
                     "ml@andreas-silberstorff.de"
                     );
    about.addAuthor( "Andreas Silberstorff", 0, "ml@andreas-silberstorff.de" );
    about.addAuthor( "Matthias Wieser", "providing many usefull MEncoder and MPlayer hints and patches", "" );

    KCmdLineArgs::init(argc, argv, &about);
    KCmdLineArgs::addCmdLineOptions(options);

    KUniqueApplication::addCmdLineOptions();
    KUniqueApplication app;

    // see if we are starting with session management
    if (app.isRestored())
    {
        RESTORE(Kalva);
    }
    else
    {
        // no session.. just start up normally
        KCmdLineArgs *args = KCmdLineArgs::parsedArgs();
        if (args->count() == 0)
        {
        }
        else
        {
            int i = 0;
            for (; i < args->count(); i++)
            {
            }
        }
        args->clear();

        app.dcopClient()->suspend();
        Kalva *kalva = new Kalva;
        //app.setMainWidget(kalva);

        KConfigGroup config(KGlobal::config(), "Kalva");
        bool startDocked = config.readBoolEntry("StartDocked", false);
        app.dcopClient()->resume();

        if(!startDocked)
        {
            kalva->show();
        }
        return app.exec();
    }
}

