//
// C++ Interface: $MODULE$
//
// Description: 
//
//
// Author: Andreas Silberstorff <andreas@andreas-silberstorff.de>, (C) 2005
//
// Copyright: See COPYING file that comes with this distribution
//
//
#ifndef MOVIEBROWSER_H
#define MOVIEBROWSER_H
#include <qstring.h>

#include "moviebrowsergui.h"
class KProcess;
class KalvaView;

class movieBrowser: public movieBrowserGui
{
        Q_OBJECT

public:
    /* default constructor */
    movieBrowser(QWidget* parent = 0,
                           const char* name = 0,
                           WFlags fl = 0 );
   /* convenience constructor */
    movieBrowser(         KalvaView* view = 0,
                           QWidget* parent = 0,
                           const char* name = 0,
                           WFlags fl = 0 );
    ~movieBrowser();

public slots:
    virtual void slotRead();
    virtual void slotDeleteMovie( const QString & jobid, bool ask );

private:
    virtual int find( const QString & jobId );

private slots:
	virtual void slotAtlsExited(KProcess * proc);
	virtual void slotAtrmExited(KProcess *);
	virtual void slotMoviesReceived(KProcess *, char* Movies, int);
	virtual void slotEditMovie();
	virtual void slotSetTooltip(int, int);

private:
    bool             m_setFocus;
    QString          m_buf;
    KalvaView       *m_view;
    KProcess        *m_atls;
    KProcess        *m_atrm;

signals:
    /* Reading done after delition */
    void signalReadingDone();
};

#endif
