#!/usr/bin/perl -w 

use lib "/usr/lib/tvapp";
use lib ".";

use strict;
use warnings;

use tvapp;

my $film          = "";
my $hour          = "";
my $minutes       = "";
my $daysoftheweek = "";
my $cmd           = "";

#program version
my $VERSION="0.00.8";

#For CVS , use following line
#my $VERSION=sprintf("%d.%02d", q$Revision: 1.1 $ =~ /(\d+)\.(\d+)/);

# Sichern der Argumente, falls wir sie nach der Auswertung noch benötigen
my @ARGS = @ARGV;

use Getopt::Long;
GetOptions (
            'film=s'          => \$film,
            'hour=s'          => \$hour,
            'minutes=s'       => \$minutes,
            'daysoftheweek=s' => \$daysoftheweek,
            'cmd=s'           => \$cmd,
            # Funktionen
            'cronaddcmd'      => sub { tvapp::cronaddcmd (
                                                     $film,
                                                     $hour,
                                                     $minutes,
                                                     $daysoftheweek,
                                                     $cmd
                                              );
                                     },
            'cronls'          => sub { tvapp::cronlsserials(); },
            'atls'            => sub { tvapp::atls(); },
            'cronrm'          => sub { tvapp::cronrmserial($film); },
);

__END__

=head1 NAME

Script name - short discription of your program

=head1 SYNOPSIS

 how to us your program

=head1 DESCRIPTION

 long description of your program

=head1 SEE ALSO

 need to know things before somebody uses your program

=head1 AUTHOR

 Andreas Silberstorff

=cut
