#include "asoundinterface.h"
#include <alsa/asoundlib.h>
#include "cards.h"
#include <sstream>

AsoundInterface::AsoundInterface()
{
}


AsoundInterface::~AsoundInterface()
{
}

/*!
    \fn AsoundInterface::nextCardInfo(cardInfo *info)
 */
void AsoundInterface::nextCardInfo(cardInfo *info)
{
	char *name = new char[255];
	int num = info->number;
	snd_card_next(&num);
	if (num != -1)
		snd_card_get_name(num, &name);
	info->name = name;
	info->number = num;
	delete name;
}

/*!
    \fn AsoundInterface::genRCEntry(Cardconfig *config)
 */
void AsoundInterface::genRCEntries(QString &string)
{
	std::ostringstream strbuf;
	
	for (int i = 0; i < cards().count(); i++) {
		Cardconfig *config = cards().getConfig(i);
		
		if (config->m_DMixDefault) {			
			genAsymEntry(config, strbuf);
			if (config->m_PlaybackDMix)
				genDMixEntry(config, strbuf);
			if (config->m_CaptureDSnoop)
				genDSnoopEntry(config, strbuf);
		}
		if (config->m_ConfigSurround && config->m_AdvancedSurround)
			genAdvancedSurroundEntry(config, strbuf);
		if (config->m_ConfigSurround && !config->m_AdvancedSurround)
			genSimpleSurroundEntry(config, strbuf);
		genPlugEntry(config, strbuf);
		if (config->m_OSSEmulation)
			genOSSEntry(config, strbuf);
		if (config->m_Default)
			genDefaultEntry(config, strbuf);
	}
	string = strbuf.str();
}

/*!
    \fn AsoundInterface::genAsymEntry(Cardconfig *config, std::ostringstream &file)
 */
void AsoundInterface::genAsymEntry(Cardconfig *config, std::ostringstream &file)
{
	file << "pcm." << config->m_ConfigName << "_asym" << "{\n";
	file << "\ttype asym\n";
	if (config->m_PlaybackDMix)
		file << "\tplayback.pcm " << config->m_ConfigName << "_dmix" << "\n";
	else
		file << "\tplayback.pcm " << config->m_ConfigName << "\n";
	if (config->m_CaptureDSnoop)
		file << "\tcapture.pcm " << config->m_ConfigName << "_dsnoop" << "\n";
	else
		file << "\tcapture.pcm " << config->m_ConfigName << "\n";
	file << "}\n\n";
}
/*!
    \fn AsoundInterface::genDMixEntry()
 */
void AsoundInterface::genDMixEntry(Cardconfig *config, std::ostringstream &file)
{
	file << "pcm." << config->m_ConfigName << "_dmix " << "{\n";
	file << "\ttype dmix\n\tipc_key 119" << config->m_CardNumber << "\n";
	file << "\tslave {\n";
	file << "\t\tpcm \"hw:" << config->m_CardNumber << ",0\"\n";
	file << "\t\tperiod_time 0\n";
	file << "\t\tperiod_size " << config->m_DMixPeriod << "\n";
	file << "\t\tbuffer_size " << config->m_DMixBuffer << "\n";
	if (config->m_PlaybackFormat)
		file << "\t\tformat " << config->m_PlaybackDataFormat << "\n";
	if (config->m_PlaybackResample)
		file << "\t\trate " << config->m_PlaybackRate << "\n";
	file << "\t}\n";
	file << "\tbindings {\n";
	file << "\t\t0 0\n\t\t1 1\n";
	file << "\t}\n}\n\n";
}

/*!
    \fn AsoundInterface::genPlugEntry(Cardconfig *config, ofstream file)
 */
void AsoundInterface::genPlugEntry(Cardconfig *config, std::ostringstream &file)
{
	file << "pcm." << config->m_ConfigName << " " << "{\n";
	file << "\ttype plug\n";
	file << "\tslave {\n";
	file << "\t\tpcm \"hw:" << config->m_CardNumber << ",0\"\n";
	if (config->m_PlaybackFormat)
		file << "\t\tformat " << config->m_PlaybackDataFormat << "\n";
	if (config->m_PlaybackResample)
		file << "\t\trate " << config->m_PlaybackRate << "\n";
	file << "\t}\n";
	file << "}\n\n";
}

/*!
    \fn AsoundInterface::genDSnoopEntry(Cardconfig *config, std::ostringstream &file)
 */
void AsoundInterface::genDSnoopEntry(Cardconfig *config, std::ostringstream &file)
{
	file << "pcm." << config->m_ConfigName << "_dsnoop " << "{\n";
	file << "\ttype dsnoop\n\tipc_key 117" << config->m_CardNumber << "\n";
	file << "\tslave {\n";	
	file << "\t\tpcm \"hw:" << config->m_CardNumber << ",0\"\n";
	file << "\t\tperiod_time 0\n";
	file << "\t\tperiod_size " << config->m_DMixPeriod << "\n";
	file << "\t\tbuffer_size " << config->m_DMixBuffer << "\n";
	if (config->m_RecordFormat)
		file << "\t\tformat " << config->m_RecordDataFormat << "\n";
	if (config->m_RecordResample)
		file << "\t\trate " << config->m_RecordRate << "\n";
	file << "\t}\n";
	file << "\tbindings {\n";
	file << "\t\t0 0\n\t\t1 1\n";
	file << "\t}\n}\n\n";
}


/*!
    \fn AsoundInterface::genOSSEntry(Cardconfig *config, std::ostringstream &file)
 */
void AsoundInterface::genOSSEntry(Cardconfig *config, std::ostringstream &file)
{
	file << "pcm.dsp" << config->m_OSSDevice << " {\n";
	file << "\ttype plug\n";
	if (config->m_DMixDefault)
		file << "\tslave.pcm " << config->m_ConfigName << "_asym\n";
	else
		file << "\tslave.pcm " << config->m_ConfigName << "\n";
	file << "}\n\n";
	file << "ctl.mixer" << config->m_OSSDevice << " {\n";
	file << "\ttype hw\n";
	file << "\tcard " << config->m_CardNumber << "\n";
	file << "}\n\n";
}


/*!
    \fn AsoundInterface::genDefaultEntry(Cardconfig *config, std::ostringstream &file)
 */
void AsoundInterface::genDefaultEntry(Cardconfig *config, std::ostringstream &file)
{
	file << "pcm.!default {\n";
	file << "\ttype plug\n";
	file << "\tslave {\n";
	if (config->m_DMixDefault)
		file << "\t\tpcm " << config->m_ConfigName << "_asym\n";
	else
		file << "\t\tpcm " << config->m_ConfigName << "\n";
	if (config->m_PlaybackFormat)
		file << "\t\tformat " << config->m_PlaybackDataFormat << "\n";
	file << "\t}\n";
	file << "}\n\n";
}

/*!
    \fn AsoundInterface::genAdvancedSurroundEntry(Cardconfig *config, std::ostringstream &file)
 */
void AsoundInterface::genAdvancedSurroundEntry(Cardconfig *config, std::ostringstream &file)
{
	file << "pcm." << config->m_ConfigName << "_surround " << "{\n";
	file << "\ttype route\n";
	file << "\tslave {\n";
	file << "\t\tpcm " << config->m_ConfigName << "\n";
	if (config->m_PlaybackFormat)
		file << "\t\tformat " << config->m_PlaybackDataFormat << "\n";
	file << "\t\tchannels " << config->m_SurroundTable.m_Channels << "\n";
	file << "\t}\n";
	//Now loop through and generate the ttable
	for (int i = 0; i < config->m_SurroundTable.m_Channels; i++)
		file << "\tttable." << config->m_SurroundTable.m_Mappings[i] << "." << i << " " << config->m_SurroundTable.m_Scale[i] << "\n";
	file << "}\n\n";
}

/*!
    \fn AsoundInterface::genSimpleSurroundEntry(Cardconfig *config, std::ostringstream &file)
 */
void AsoundInterface::genSimpleSurroundEntry(Cardconfig *config, std::ostringstream &file)
{
	file << "pcm." << config->m_ConfigName << "_surround " << "{\n";
	file << "\ttype plug\n";
	file << "\troute_policy " << config->m_SurroundMode << "\n";
	file << "\tslave {\n";
	file << "\t\tpcm " << config->m_ConfigName << "\n";	
	if (config->m_PlaybackFormat)
		file << "\t\tformat " << config->m_PlaybackDataFormat << "\n";
	file << "\t\tchannels " << config->m_SurroundTable.m_Channels << "\n";
	file << "\t}\n}\n\n";
}
