#ifndef ASOUNDINTERFACE_H
#define ASOUNDINTERFACE_H
#include <qstring.h>
#include "cardconfig.h"
#include <iostream>
#include <sstream>


struct cardInfo {
	QString name;
	int number;
};

/**
@author Marc Brooker
*/
class AsoundInterface {
public:
	AsoundInterface();
	
	~AsoundInterface();
	static void nextCardInfo(cardInfo *info);
	static void genRCEntries(QString &string);
	
	
private:
	static void genDMixEntry(Cardconfig *config, std::ostringstream &file);
	static void genPlugEntry(Cardconfig *config, std::ostringstream &file);
    static void genDSnoopEntry(Cardconfig *config, std::ostringstream &file);
    static void genAsymEntry(Cardconfig *config, std::ostringstream &file);
    static void genOSSEntry(Cardconfig *config, std::ostringstream &file);
    static void genDefaultEntry(Cardconfig *config, std::ostringstream &file);
    static void genAdvancedSurroundEntry(Cardconfig *config, std::ostringstream &file);
    static void genSimpleSurroundEntry(Cardconfig *config, std::ostringstream &file);

};

#endif
