#include <kapplication.h>
#include <kconfig.h>
#include <qvariant.h>
#include "cardconfig.h"

Cardconfig::Cardconfig(QString name, int number):
m_CardName(name), m_CardNumber(number)
{	
	m_ConfigName = m_CardName + QString("_%1").arg(number);
	m_ConfigName.remove(" ");
}


Cardconfig::~Cardconfig()
{
}

/*!
    \fn Cardconfig::write()
 */
void Cardconfig::write()
{
    KConfig *conf = kapp->config();
    conf->setGroup(m_CardName);
    //Write the card settings
    conf->writeEntry("PlaybackDMix", m_PlaybackDMix);
    conf->writeEntry("DMixDefault", m_DMixDefault);
    conf->writeEntry("DMixBuffer", m_DMixBuffer);
    conf->writeEntry("DMixPeriod", m_DMixPeriod);
    conf->writeEntry("CaptureDSnoop", m_CaptureDSnoop);
    conf->writeEntry("OSSEmulate", m_OSSEmulation);
    conf->writeEntry("OSSDevice", m_OSSDevice);
    conf->writeEntry("Default", m_Default);
    conf->writeEntry("MmapEmulation", m_EnableMmap);
    
    conf->writeEntry("PlaybackResample", m_PlaybackResample);
    conf->writeEntry("PlaybackResampleRate", m_PlaybackRate);
    conf->writeEntry("PlaybackSetFormat", m_PlaybackFormat);
    conf->writeEntry("PlaybackFormat", m_PlaybackDataFormat);
    
    conf->writeEntry("CaptureResample", m_RecordResample);
    conf->writeEntry("CaptureResampleRate", m_RecordRate);
    conf->writeEntry("CaptureSetFormat", m_RecordFormat);
    conf->writeEntry("CaptureFormat", m_RecordDataFormat);
    //Surround Settings
    conf->writeEntry("ConfigSurround", m_ConfigSurround);
    conf->writeEntry("AdvancedSurround", m_AdvancedSurround);
    conf->writeEntry("SurroundMode", m_SurroundMode);
    conf->writeEntry("Channels", m_SurroundTable.m_Channels);
    for (int i = 0; i < MAX_CHANNELS; i++) {
	    conf->writeEntry("Channel" + QString("%1").arg(i) + "_source", m_SurroundTable.m_Mappings[i]);
	    conf->writeEntry("Channel" + QString("%1").arg(i) + "_scale", m_SurroundTable.m_Scale[i]);
    }
}


/*!
    \fn Cardconfig::read()
 */
void Cardconfig::read()
{
	KConfig *conf = kapp->config();
	conf->setGroup(m_CardName);
	m_PlaybackDMix = conf->readPropertyEntry("PlaybackDMix", QVariant::Bool).toBool();
	m_DMixDefault = conf->readPropertyEntry("DMixDefault", QVariant::Bool).toBool();
	m_CaptureDSnoop = conf->readPropertyEntry("CaptureDSnoop", QVariant::Bool).toBool();
	m_OSSEmulation = conf->readPropertyEntry("OSSEmulate", QVariant::Bool).toBool();
	m_OSSDevice = conf->readEntry("OSSDevice", "0");
	m_DMixBuffer = conf->readEntry("DMixBuffer", "8192");
	m_DMixPeriod = conf->readEntry("DMixPeriod", "1024");
	m_Default = conf->readPropertyEntry("Default", QVariant::Bool).toBool();
	m_EnableMmap = conf->readPropertyEntry("MmapEmulation", QVariant::Bool).toBool();
	
	m_PlaybackResample = conf->readPropertyEntry("PlaybackResample", QVariant::Bool).toBool();
	m_PlaybackRate = conf->readEntry("PlaybackResampleRate", "44100");
	m_PlaybackFormat = conf->readPropertyEntry("PlaybackSetFormat", QVariant::Bool).toBool();
	m_PlaybackDataFormat = conf->readEntry("PlaybackFormat", "S16_LE");
	
	m_RecordResample = conf->readPropertyEntry("CaptureResample", QVariant::Bool).toBool();
	m_RecordRate = conf->readEntry("CaptureResampleRate", "44100");
	m_RecordFormat = conf->readPropertyEntry("CaptureSetFormat", QVariant::Bool).toBool();
	m_RecordDataFormat = conf->readEntry("CaptureFormat", "S16_LE");
	//Surround Settings
	m_ConfigSurround = conf->readPropertyEntry("ConfigSurround", QVariant::Bool).toBool();
	m_AdvancedSurround = conf->readPropertyEntry("AdvancedSurround", QVariant::Bool).toBool();
	m_SurroundMode = conf->readEntry("SurroundMode", "default");
	m_SurroundTable.m_Channels = conf->readPropertyEntry("Channels", QVariant::Int).toInt();
	for (int i = 0; i < MAX_CHANNELS; i++) {
		m_SurroundTable.m_Mappings[i] = conf->readPropertyEntry("Channel" + QString("%1").arg(i) + "_source", QVariant::Int).toInt();
		m_SurroundTable.m_Scale[i] = conf->readPropertyEntry("Channel" + QString("%1").arg(i) + "_scale", QVariant::Double).toDouble();
	}
}