#ifndef CARDCONFIG_H
#define CARDCONFIG_H
#include <qstring.h>

#define MAX_CHANNELS 8

struct SurroundTable {
	int m_Channels;
	int m_Mappings[MAX_CHANNELS];
	float m_Scale[MAX_CHANNELS];
};

/**
@author Marc Brooker
*/
class Cardconfig{
public:
    Cardconfig(QString name, int number);
    ~Cardconfig();
    void write();
    void read();
   
    
   
    //Configuration variables
    bool m_PlaybackDMix; ///Is DMix enabled for this card
    bool m_CaptureDSnoop;
    bool m_DMixDefault;
    bool m_PlaybackResample; ///Resample frequency for this card
    bool m_RecordResample;
    bool m_RecordFormat;
    bool m_PlaybackFormat;
    bool m_Default;
    bool m_EnableMmap;
    //Surround Settings
    bool m_ConfigSurround;
    bool m_AdvancedSurround;
    QString m_SurroundMode;
    SurroundTable m_SurroundTable;
    //Configuration Strings
    QString m_ConfigName;
    QString m_RecordRate;
    QString m_PlaybackRate; ///Resample rate for playback
    QString m_RecordDataFormat; ///Data format for this card
    QString m_PlaybackDataFormat;
    QString m_CardName; ///Name of this card
    QString m_DMixBuffer;
    QString m_DMixPeriod;
    //OSS Settings
    bool m_OSSEmulation;
    QString m_OSSDevice;
    int m_CardNumber;
};

#endif
