#include <klocale.h>
#include "cardsettingsdialog.h"
#include <qcheckbox.h>
#include <qcombobox.h>
#include <qtable.h>
#include <qheader.h>
#include <qradiobutton.h>
#include <qlabel.h>
#include <qheader.h>

//These are not all the ALSA formats - if you need others, add them to the list
char formats[][19] = {"S8", "U8", "S16_LE", "S16_BE", "U16_LE", "U16_BE", "S24_LE", "S24_BE", "U24_LE", "U24_BE", "S32_LE", "S32_BE", "U32_LE", "U32_BE", "FLOAT_LE", "FLOAT_BE", "FLOAT64_LE", "FLOAT64_BE", 0 };
char rates[][12] = {"8000", "9600", "11025", "22050", "24000", "32000", "44100", "48000", "88200", "96000", "192000", 0};
char buffer_period[][12] = {"64", "128", "256", "512", "1024", "2048", "4096", "8192", "16384", "32768", "65536", 0 };
char channels[][9] = {"1", "2", "3", "4", "5", "6", "7", "8", 0 };
char oss_devices[][11] = {"0", "1", "2", "3", "4", "5", "6", "7", "8", "9", 0};
char surround_modes[][10] = {"default", "average", "copy", "duplicate", 0 };

CardSettingsDialog::CardSettingsDialog(Cardconfig *card, QWidget *parent, const char *name)
 : CardSettings(parent, name), card(card)
{
	int i;
	
	//Load all the combo boxes with values
	for (i = 0; formats[i][0] != 0; i++) {
		m_FormatPlayback->insertItem(formats[i]);
		m_FormatRecord->insertItem(formats[i]);
	}
	for (i = 0; rates[i][0] != 0; i++) {
		m_PlaybackResampleRate->insertItem(rates[i]);
		m_RecordResampleRate->insertItem(rates[i]);
	}
	for (i = 0; buffer_period[i][0] != 0; i++) {
		m_PeriodDMix->insertItem(buffer_period[i]);
		m_BufferDMix->insertItem(buffer_period[i]);
	}
	for (i = 0; channels[i][0] != 0; i++) {
		m_Channels->insertItem(channels[i]);
	}
	for (i = 0; surround_modes[i][0] != 0; i++) {
		m_SurroundMode->insertItem(i18n(surround_modes[i]));
	}
	for (i = 0; oss_devices[i][0] != 0; i++) {
		m_OSSDevice->insertItem(oss_devices[i]);
	}
	//Set the headings for the surround table
	m_SurroundTable->horizontalHeader()->setLabel(0, i18n("Source"));
	m_SurroundTable->horizontalHeader()->setLabel(1, i18n("Scale"));
	for (i = 0; i < MAX_CHANNELS; i++)
		m_SurroundTable->verticalHeader()->setLabel(i, QString("%1").arg(i));
	connect (m_OSSDevice, SIGNAL ( activated(const QString &) ), this, SLOT (setOSSLabel (const QString& )));
	connect (m_Channels , SIGNAL ( textChanged(const QString &) ), this, SLOT (setTableRows (const QString& )));
}


CardSettingsDialog::~CardSettingsDialog()
{
}

#include "cardsettingsdialog.moc"

/*!
    \fn CardSettingsDialog::updateConfig()
 */
void CardSettingsDialog::updateConfig()
{
	//Set all UI elements with card settings
	card->m_PlaybackDMix = m_DMixPlayback->isChecked();
	card->m_CaptureDSnoop = m_DSnoopCapture->isChecked();
	card->m_DMixBuffer = m_BufferDMix->currentText();
	card->m_DMixPeriod = m_PeriodDMix->currentText();
	card->m_OSSEmulation = m_EnableOSS->isChecked();
	card->m_OSSDevice = m_OSSDevice->currentText();
	card->m_EnableMmap = m_EnableMmap->isChecked();
	
	card->m_PlaybackResample = m_ResamplePlayback->isChecked();
	card->m_PlaybackRate = m_PlaybackResampleRate->currentText();
	card->m_PlaybackFormat = m_SetFormatPlayback->isChecked();
	card->m_PlaybackDataFormat = m_FormatPlayback->currentText();
	
	card->m_RecordResample = m_ResampleRecord->isChecked();
	card->m_RecordRate = m_RecordResampleRate->currentText();
	card->m_RecordFormat = m_SetFormatRecord->isChecked();
	card->m_RecordDataFormat = m_FormatRecord->currentText();
	//Surround Setting Elements
	card->m_AdvancedSurround = m_AdvancedSurround->isChecked();	
	card->m_SurroundMode = m_SurroundMode->currentText();
	card->m_SurroundTable.m_Channels = m_Channels->currentText().toInt();
	card->m_ConfigSurround = m_ConfigSurround->isChecked();
	for (int i = 0; i < card->m_SurroundTable.m_Channels; i++) {
		QTableItem *temp;
		temp = m_SurroundTable->item(i, 0);
		if (temp)
			card->m_SurroundTable.m_Mappings[i] = temp->text().toInt();
		else
			card->m_SurroundTable.m_Mappings[i] = 0;
		temp = m_SurroundTable->item(i, 1);
		if (temp)
			card->m_SurroundTable.m_Scale[i] = temp->text().toInt();
		else
			card->m_SurroundTable.m_Scale[i] = 0;		
	}
	
	card->write();
}

/*!
    \fn CardSettingsDialog::updateDialog()
 */
void CardSettingsDialog::updateDialog() const
{
	card->read();
	m_DMixPlayback->setChecked(card->m_PlaybackDMix);
	m_DSnoopCapture->setChecked(card->m_CaptureDSnoop);
	m_BufferDMix->setCurrentText(card->m_DMixBuffer);
	m_PeriodDMix->setCurrentText(card->m_DMixPeriod);
	m_DefaultDMix->setChecked(card->m_DMixDefault);	
	m_EnableMmap->setChecked(card->m_EnableMmap);
	
	m_ResamplePlayback->setChecked(card->m_PlaybackResample);
	m_PlaybackResampleRate->setCurrentText(card->m_PlaybackRate);
	m_SetFormatPlayback->setChecked(card->m_PlaybackFormat);
	m_FormatPlayback->setCurrentText(card->m_PlaybackDataFormat);
	
	m_ResampleRecord->setChecked(card->m_RecordResample);
	m_RecordResampleRate->setCurrentText(card->m_RecordRate);
	m_SetFormatRecord->setChecked(card->m_RecordFormat);
	m_FormatRecord->setCurrentText(card->m_RecordDataFormat);
	//Surround Settings
	m_AdvancedSurround->setChecked(card->m_AdvancedSurround);
	m_SimpleSurround->setChecked(!card->m_AdvancedSurround);
	m_SurroundMode->setCurrentText(card->m_SurroundMode);
	m_Channels->setCurrentText(QString("%1").arg(card->m_SurroundTable.m_Channels));
	m_ConfigSurround->setChecked(card->m_ConfigSurround);
	m_SurroundTable->setNumRows(card->m_SurroundTable.m_Channels);
	for (int i = 0; i < card->m_SurroundTable.m_Channels; i++) {		
		m_SurroundTable->setText(i, 0, QString("%1").arg(card->m_SurroundTable.m_Mappings[i]));
		m_SurroundTable->setText(i, 1, QString("%1").arg(card->m_SurroundTable.m_Scale[i]));
	}
	//OSS Settings
	m_EnableOSS->setChecked(card->m_OSSEmulation);
	m_OSSDevice->setCurrentText(card->m_OSSDevice);	
	if (card->m_OSSDevice == "0")
		m_OSSDevLabel->setText("/dev/dsp");
	else
		m_OSSDevLabel->setText("/dev/dsp"+card->m_OSSDevice);
}

/*!
    \fn CardSettingsDialog::setTableRows(const QString &string)
 */
void CardSettingsDialog::setTableRows(const QString &string)
{
	
	int i;
	int rows = string.toInt();
	int prev_rows = m_SurroundTable->numRows();
	if (rows < 1)
		rows = 1;
	if (rows > 8)
		rows = 8;
	m_SurroundTable->setNumRows(rows);
	if (prev_rows < rows) {
		for (i = prev_rows; i < rows; i++) {			
			m_SurroundTable->setText(i, 0, QString("%1").arg(card->m_SurroundTable.m_Mappings[i]));
			m_SurroundTable->setText(i, 1, QString("%1").arg(card->m_SurroundTable.m_Scale[i]));
		}
		
		for (i = 0; i < rows; i++) {
			m_SurroundTable->verticalHeader()->setLabel(i, QString("%1").arg(i));
		}
	}
}

/*!
    \fn CardSettingsDialog::setOSSDevice(const QString &string)
 */
void CardSettingsDialog::setOSSLabel(const QString &string)
{
	if (string == "0")
		m_OSSDevLabel->setText("/dev/dsp");
	else
		m_OSSDevLabel->setText("/dev/dsp"+string);
}
