#include "generaldialog.h"
#include "cardconfig.h"
#include "cards.h"

#include "qradiobutton.h"
#include "qbuttongroup.h"
#include "qlayout.h"


GeneralDialog::GeneralDialog(MainDialog *mainDlg, QWidget *parent, const char *name)
	: GeneralTab(parent, name), mainDlg (mainDlg),
        selectedDevice(0)
{
    defaultDevice->setColumnLayout(0, Qt::Vertical );
}

GeneralDialog::~GeneralDialog()
{
}

/**
\fn OutputDialog::updateDialog()
            
Depends on cards() already containing the actual sound cards.
 */

void GeneralDialog::init()
{
    QVBoxLayout *buttonGroupLayout = new QVBoxLayout(defaultDevice->layout());
    for (int i = 0; i < cards().count(); i++)
    {
        Cardconfig* card = cards().getConfig(i);
        QRadioButton *checkbox = new QRadioButton(card->m_CardName, defaultDevice);
        buttonGroupLayout->addWidget(checkbox);
    }
    
    defaultDevice->setButton(selectedDevice);
    
    connect(defaultDevice, SIGNAL( clicked(int) ), this, SLOT ( defaultDeviceChanged(int) ) );
}

// #include "generaldialog.moc"

void GeneralDialog::defaultDeviceChanged(int id)
{
    for (int i = 0; i < cards().count(); i++)
    {
        Cardconfig* config = cards().getConfig(i);
        config->m_Default = (i == id);
    }
}

