/*
KAsound - a KDE frontend for the configuration of .asoundrc
    Copyright (C) 2005 Marc Brooker <marcbrooker@gmail.com>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
#include "kasound.h"
#include <qlabel.h>
#include <kmainwindow.h>
#include <klocale.h>
#include <kapplication.h>
#include "asoundinterface.h"
#include "cards.h"
#include "cardconfig.h"

kasound::kasound()
    : KMainWindow( 0, "kasound" )
{
    mainDialog = new MainDialog(this);
    scanCards();
    mainDialog->exec();
    mainDialog->updateConfig();
    kapp->exit(0);
}

kasound::~kasound()
{
}

#include "kasound.moc"


/*!
    \fn kasound::executeMainDlg()
 */
void kasound::executeMainDlg()
{

}


/*!
    \fn kasound::scanCards()
 */
bool kasound::scanCards()
{
	cardInfo info;
	Cardconfig *config;
	info.number = -1;
	AsoundInterface::nextCardInfo(&info);
	while (info.number != -1) {
		config = new Cardconfig(info.name, info.number);
		cards().addConfig(config);
		mainDialog->addCard(config);
		AsoundInterface::nextCardInfo(&info);
	}
	return true;
}
