/*
KAsound - a KDE frontend for the configuration of .asoundrc
    Copyright (C) 2005 Marc Brooker <marcbrooker@gmail.com>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include "maindialog.h"
#include <kapplication.h>
#include <kaboutdata.h>
#include <kcmdlineargs.h>
#include <klocale.h>

static const char description[] =
    I18N_NOOP("A Frontend for the configuration of .asoundrc");

static const char version[] = "0.4";

static KCmdLineOptions options[] =
{
//    { "+[URL]", I18N_NOOP( "Document to open" ), 0 },
    KCmdLineLastOption
};

int main(int argc, char **argv)
{
    KAboutData about("kasound", I18N_NOOP("kasound"), version, description,
		     KAboutData::License_GPL, "(C) 2005 Marc Brooker", 0, 0, "marcbrooker@gmail.com");
    about.addAuthor( "Marc Brooker", 0, "marcbrooker@gmail.com" );
    KCmdLineArgs::init(argc, argv, &about);
    KCmdLineArgs::addCmdLineOptions( options );
    KApplication app;
	MainDialog *mainWin = 0;

	mainWin = new MainDialog();
		app.setMainWidget( mainWin );
		mainWin->show();
		 
    // mainWin has WDestructiveClose flag by default, so it will delete itself.
    return app.exec();
}

