#include <qlayout.h>
#include <qlabel.h>
#include <qframe.h>
#include <klocale.h>
#include <kiconloader.h>
#include <kglobal.h>
#include "maindialog.h"
#include "outputdialog.h"
#include "generaldialog.h"
#include "asoundinterface.h"
#include "cards.h"
#include "cardconfig.h"


MainDialog::MainDialog(QWidget *parent, const char *name)
 : KDialogBase(IconList, i18n("Alsa Configuration"), Default|Close, Close, parent, name)
{
    QFrame *generalFrame = addPage(i18n("General"), i18n("General"), KGlobal::iconLoader()->loadIcon("kcontrol", KIcon::Panel, 0, false));
    QVBoxLayout *generalFrameLayout = new QVBoxLayout(generalFrame, 0, 0);
    GeneralDialog *generalDialog = new GeneralDialog(this, generalFrame);
    generalFrameLayout->addWidget(generalDialog);

    scanCards();

    // has to be initialized after scanCards (it needs the cards vector)
	generalDialog->init();
    
    QFrame *frame = addPage(i18n("Output"), i18n("Output"), KGlobal::iconLoader()->loadIcon("kfm", KIcon::Panel, 0, false));
    QVBoxLayout *framelayout = new QVBoxLayout(frame, 0, 0);
    OutputDialog *setDialog = new OutputDialog(this, frame);
    framelayout->addWidget(setDialog);
}

MainDialog::~MainDialog()
{
}


#include "maindialog.moc"

/*!
    \fn MainDialog::scanCards()
 */
bool MainDialog::scanCards()
{
	cardInfo info;
	Cardconfig *config;
	info.number = -1;
	AsoundInterface::nextCardInfo(&info);
	while (info.number != -1) 
	{
		config = new Cardconfig(info.name, info.number);
		cards().addConfig(config);
		addCard(config);
		AsoundInterface::nextCardInfo(&info);
	}
	
	return true;
}

/*!
    \fn MainDialog::addCard(Cardconfig *card)
 */
void MainDialog::addCard(Cardconfig *card)
{
	CardSettingsDialog *setDialog;
	QFrame *frame = addPage(card->m_CardName, card->m_CardName, KGlobal::iconLoader()->loadIcon("kmix", KIcon::Panel, 0, false));
	QVBoxLayout *framelayout = new QVBoxLayout(frame, 0, 0);
	setDialog = new CardSettingsDialog(card, frame);
	pages.push_back(setDialog);
	setDialog->updateDialog();
	framelayout->addWidget(pages.back());
}

/*!
    \fn MainDialog::updateConfig()
 */
void MainDialog::updateConfig()
{
	for (unsigned int i = 0; i < pages.size(); i++) {
		pages[i]->updateConfig();		
	}		
}

